/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.testng.annotations.Test;

@Test
public class ImagePredicatesTest {
    ComputeService computeService = ((ComputeServiceContext)ContextBuilder.newBuilder((String)"stub").build(ComputeServiceContext.class)).getComputeService();

    public void testImageId() {
        Image first = (Image)Iterables.get((Iterable)this.computeService.listImages(), (int)0);
        assert (ImagePredicates.idEquals((String)first.getId()).apply((Object)first));
        Image second = (Image)Iterables.get((Iterable)this.computeService.listImages(), (int)1);
        assert (!ImagePredicates.idEquals((String)first.getId()).apply((Object)second));
    }

    public void testUserMetadataContains() {
        Image first = (Image)Iterables.get((Iterable)this.computeService.listImages(), (int)0);
        first = ImageBuilder.fromImage((Image)first).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        assert (ImagePredicates.userMetadataContains((String)"foo", (String)"bar").apply((Object)first));
        Image second = (Image)Iterables.get((Iterable)this.computeService.listImages(), (int)1);
        second = ImageBuilder.fromImage((Image)second).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"baz")).build();
        assert (!ImagePredicates.userMetadataContains((String)"foo", (String)"bar").apply((Object)second));
    }
}

