/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.TemplateOptionsToStatement;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.util.OpenSocketFinder;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapTest")
public class CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapTest {
    public void testBreakOnIllegalStateExceptionDuringPollNode() {
        InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)EasyMock.createMock(InitializeRunScriptOnNodeOrPlaceInBadMap.Factory.class);
        OpenSocketFinder openSocketFinder = (OpenSocketFinder)EasyMock.createMock(OpenSocketFinder.class);
        TemplateOptionsToStatement templateOptionsToStatement = new TemplateOptionsToStatement();
        Object statement = null;
        TemplateOptions options = new TemplateOptions();
        LinkedHashSet goodNodes = Sets.newLinkedHashSet();
        LinkedHashMap badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap customizationResponses = LinkedHashMultimap.create();
        final NodeMetadata pendingNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.PENDING).build();
        Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> pollNodeRunning = new Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>>(){

            public AtomicReference<NodeMetadata> apply(AtomicReference<NodeMetadata> node) {
                Assert.assertEquals((Object)node.get(), (Object)pendingNode);
                throw new IllegalStateException("bad state!");
            }
        };
        EasyMock.replay((Object[])new Object[]{initScriptRunnerFactory, openSocketFinder});
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        new CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap((Function)pollNodeRunning, openSocketFinder, (Function)templateOptionsToStatement, initScriptRunnerFactory, options, atomicNode, (Set)goodNodes, (Map)badNodes, (Multimap)customizationResponses).apply(atomicNode);
        Assert.assertEquals((int)goodNodes.size(), (int)0);
        Assert.assertEquals(badNodes.keySet(), (Set)ImmutableSet.of((Object)pendingNode));
        Assert.assertEquals((String)((Exception)badNodes.get(pendingNode)).getMessage(), (String)"bad state!");
        Assert.assertEquals((int)customizationResponses.size(), (int)0);
        EasyMock.verify((Object[])new Object[]{initScriptRunnerFactory, openSocketFinder});
    }

    public void testBreakGraceWhenNodeSocketFailsToOpen() {
        int portTimeoutSecs = 2;
        InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)EasyMock.createMock(InitializeRunScriptOnNodeOrPlaceInBadMap.Factory.class);
        OpenSocketFinder openSocketFinder = (OpenSocketFinder)EasyMock.createMock(OpenSocketFinder.class);
        TemplateOptionsToStatement templateOptionsToStatement = new TemplateOptionsToStatement();
        TemplateOptions options = new TemplateOptions().blockOnPort(22, portTimeoutSecs);
        LinkedHashSet goodNodes = Sets.newLinkedHashSet();
        LinkedHashMap badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap customizationResponses = LinkedHashMultimap.create();
        final NodeMetadata pendingNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.PENDING).build();
        final NodeMetadata runningNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build();
        EasyMock.expect((Object)openSocketFinder.findOpenSocketOnNode(runningNode, 22, (long)portTimeoutSecs, TimeUnit.SECONDS)).andThrow((Throwable)new NoSuchElementException("could not connect to any ip address port")).once();
        Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> pollNodeRunning = new Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>>(){

            public AtomicReference<NodeMetadata> apply(AtomicReference<NodeMetadata> node) {
                Assert.assertEquals((Object)node.get(), (Object)pendingNode);
                node.set(runningNode);
                return node;
            }
        };
        EasyMock.replay((Object[])new Object[]{initScriptRunnerFactory, openSocketFinder});
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        new CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap((Function)pollNodeRunning, openSocketFinder, (Function)templateOptionsToStatement, initScriptRunnerFactory, options, atomicNode, (Set)goodNodes, (Map)badNodes, (Multimap)customizationResponses).apply(atomicNode);
        Assert.assertEquals((int)goodNodes.size(), (int)0);
        Assert.assertEquals(badNodes.keySet(), (Set)ImmutableSet.of((Object)pendingNode));
        ((Exception)badNodes.get(pendingNode)).printStackTrace();
        Assert.assertEquals((String)((Exception)badNodes.get(pendingNode)).getMessage(), (String)"could not connect to any ip address port");
        Assert.assertEquals((int)customizationResponses.size(), (int)0);
        EasyMock.verify((Object[])new Object[]{initScriptRunnerFactory, openSocketFinder});
    }
}

