/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.impl.ReturnCredentialsBoundToImage;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ReturnCredentialsBoundToImageTest")
public class ReturnCredentialsBoundToImageTest {
    LoginCredentials creds = LoginCredentials.builder().user("ubuntu").password("foo").build();

    public void testDefaultIsToReturnConfiguredCredential() {
        Image image = (Image)EasyMock.createMock(Image.class);
        EasyMock.replay((Object[])new Object[]{image});
        Assert.assertEquals((Object)new ReturnCredentialsBoundToImage(this.creds, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()).apply((Object)image), (Object)this.creds);
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testDefaultIsToReturnConfiguredCredentialInStore() {
        Image image = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)image.getId()).andReturn((Object)"1").times(2);
        EasyMock.replay((Object[])new Object[]{image});
        Assert.assertEquals((Object)new ReturnCredentialsBoundToImage(null, (Map)ImmutableMap.of((Object)"image#1", (Object)this.creds), (Map)ImmutableMap.of()).apply((Object)image), (Object)this.creds);
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testReturnLoginCredentialAssociatedToOsFamily() {
        Image image = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)image.getId()).andReturn((Object)"1");
        EasyMock.expect((Object)image.getOperatingSystem()).andReturn((Object)OperatingSystem.builder().family(OsFamily.WINDOWS).description("foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{image});
        Credentials creds = new Credentials("Administrator", null);
        Assert.assertEquals((Object)new ReturnCredentialsBoundToImage(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)OsFamily.WINDOWS, (Object)LoginCredentials.builder().user("Administrator").build())).apply((Object)image), (Object)creds);
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testReturnRootWhenNotOnWindows() {
        Image image = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)image.getId()).andReturn((Object)"1");
        EasyMock.expect((Object)image.getOperatingSystem()).andReturn((Object)OperatingSystem.builder().family(OsFamily.LINUX).description("foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{image});
        Credentials creds = new Credentials("root", null);
        Assert.assertEquals((Object)new ReturnCredentialsBoundToImage(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()).apply((Object)image), (Object)creds);
        EasyMock.verify((Object[])new Object[]{image});
    }
}

