/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import org.jclouds.cim.xml.VirtualSystemSettingDataHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.xml.EnvelopeHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class EnvelopeHandlerTest {
    public void testVCloud1_0() {
        Envelope result = EnvelopeHandlerTest.parseEnvelope();
        EnvelopeHandlerTest.checkOvfEnvelope(result);
    }

    public static Envelope parseEnvelope() {
        InputStream is = EnvelopeHandlerTest.class.getResourceAsStream("/ovf.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Envelope result = (Envelope)factory.create((ParseSax.HandlerWithResult)injector.getInstance(EnvelopeHandler.class)).parse(is);
        return result;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testThrowIllegalArgumentAsWeDontYetSupportVirtualSystemCollections() {
        InputStream is = this.getClass().getResourceAsStream("/ovf-vcd1.5.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        ((Envelope)factory.create((ParseSax.HandlerWithResult)injector.getInstance(EnvelopeHandler.class)).parse(is)).getVirtualSystem();
    }

    static void checkOvfEnvelope(Envelope result) {
        VirtualSystemSettingDataHandlerTest.checkVirtualSystem(result.getVirtualSystem());
    }
}

