/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.Network;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.xml.NetworkSectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NetworkSectionHandlerTest {
    public void test() {
        InputStream is = this.getClass().getResourceAsStream("/networksection.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        NetworkSection result = (NetworkSection)factory.create((ParseSax.HandlerWithResult)injector.getInstance(NetworkSectionHandler.class)).parse(is);
        Assert.assertEquals((String)result.toString(), (String)NetworkSection.builder().info("List of logical networks used in the package").network(Network.builder().name("red").description("The network the Red service is available on").build()).network(Network.builder().name("blue").description("The network the Blue service is available on").build()).build().toString());
    }
}

