/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Volume;
import org.jclouds.javax.annotation.Nullable;

public class VolumeImpl
implements Volume {
    private final String id;
    private final Volume.Type type;
    @Nullable
    private final Float size;
    @Nullable
    private final String device;
    private final boolean bootDevice;
    private final boolean durable;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeImpl that = (VolumeImpl)VolumeImpl.class.cast(o);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.getType()), (Object)((Object)that.getType())) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.device, (Object)that.device) && Objects.equal((Object)this.bootDevice, (Object)that.bootDevice) && Objects.equal((Object)this.durable, (Object)that.durable);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.size, this.device, this.bootDevice, this.durable});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("id", (Object)this.id).add("type", (Object)this.getType()).add("size", (Object)this.size).add("device", (Object)this.device).add("bootDevice", this.bootDevice).add("durable", this.durable);
    }

    public VolumeImpl(@Nullable String id, Volume.Type type, @Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this.id = id;
        this.type = (Volume.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.size = size;
        this.device = device;
        this.bootDevice = bootDevice;
        this.durable = durable;
    }

    public VolumeImpl(@Nullable Float size, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, null, bootDevice, durable);
    }

    public VolumeImpl(@Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, device, bootDevice, durable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Volume.Type getType() {
        return this.type;
    }

    @Override
    public Float getSize() {
        return this.size;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isBootDevice() {
        return this.bootDevice;
    }
}

