/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.domain.Credentials;
import org.jclouds.events.config.EventBusModule;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.location.Provider;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.CredentialStoreModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ContextBuilderTest")
public class ContextBuilderTest {
    private ContextBuilder testContextBuilder() {
        return ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost"));
    }

    @Test
    public void testVariablesReplaceOnEndpoint() {
        ContextBuilder withVariablesToReplace = this.testContextBuilder().endpoint("http://${jclouds.identity}.service.com").credentials("foo", "bar");
        URI endpoint = (URI)((Supplier)withVariablesToReplace.buildInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}, Provider.class))).get();
        Assert.assertEquals((Object)endpoint, (Object)URI.create("http://foo.service.com"));
    }

    @Test
    public void testContextName() {
        ContextBuilder withNoName = this.testContextBuilder().endpoint("http://${jclouds.identity}.service.com").name("mytest").credentials("foo", "bar");
        Context context = withNoName.build();
        Assert.assertEquals((String)context.getName(), (String)"mytest");
    }

    @Test
    public void testProviderMetadataBoundWithCorrectEndpoint() {
        ContextBuilder withVariablesToReplace = this.testContextBuilder().endpoint("http://${jclouds.identity}.service.com").credentials("foo", "bar");
        String endpoint = ((ProviderMetadata)withVariablesToReplace.buildInjector().getInstance(ProviderMetadata.class)).getEndpoint();
        Assert.assertEquals((String)endpoint, (String)"http://foo.service.com");
    }

    @Test
    public void testProviderMetadataWithEmptyIsoCodePropertyHasEmptySet() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.iso3166-codes", "");
        ContextBuilder withVariablesToReplace = this.testContextBuilder().overrides(overrides).credentials("foo", "bar");
        Set codes = ((ProviderMetadata)withVariablesToReplace.buildInjector().getInstance(ProviderMetadata.class)).getIso3166Codes();
        Assert.assertEquals((Set)codes, (Set)ImmutableSet.of());
    }

    @Test
    public void testProviderMetadataWithCredentialsSetViaProperty() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.identity", "foo");
        overrides.setProperty("jclouds.credential", "BAR");
        ContextBuilder withCredsInProps = this.testContextBuilder().overrides(overrides);
        Credentials creds = (Credentials)((Supplier)withCredsInProps.buildInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Credentials>>(){}, Provider.class))).get();
        Assert.assertEquals((Object)creds, (Object)new Credentials("foo", "BAR"));
    }

    @Test
    public void testProviderMetadataWithCredentialsSetSupplier() {
        ContextBuilder withCredsSupplier = this.testContextBuilder().credentialsSupplier(Suppliers.ofInstance((Object)new Credentials("foo", "BAR")));
        Credentials creds = (Credentials)((Supplier)withCredsSupplier.buildInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Credentials>>(){}, Provider.class))).get();
        Assert.assertEquals((Object)creds, (Object)new Credentials("foo", "BAR"));
    }

    @Test
    public void testProviderMetadataWithVersionSetViaProperty() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.api-version", "1.1");
        ContextBuilder withVersionInProps = this.testContextBuilder().overrides(overrides);
        String version = (String)withVersionInProps.buildInjector().getInstance(Key.get(String.class, ApiVersion.class));
        Assert.assertEquals((String)version, (String)"1.1");
    }

    @Test
    public void testAddHttpModuleIfNotPresent() {
        ArrayList modules = Lists.newArrayList();
        HttpModule module = new HttpModule();
        modules.add(module);
        ContextBuilder.addHttpModuleIfNeededAndNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)1);
        Assert.assertEquals(modules.remove(0), (Object)((Object)module));
    }

    @Test
    public void testAddLoggingModuleIfNotPresent() {
        ArrayList modules = Lists.newArrayList();
        NullLoggingModule module = new NullLoggingModule();
        modules.add(module);
        ContextBuilder.addLoggingModuleIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)1);
        Assert.assertEquals(modules.remove(0), (Object)module);
    }

    @Test
    public void testAddEventBusModuleIfNotPresent() {
        ArrayList modules = Lists.newArrayList();
        EventBusModule module = new EventBusModule();
        modules.add(module);
        ContextBuilder.addEventBusIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)1);
        Assert.assertEquals(modules.remove(0), (Object)module);
    }

    @Test
    public void testAddExecutorServiceModuleIfNotPresent() {
        ArrayList modules = Lists.newArrayList();
        ExecutorServiceModule module = new ExecutorServiceModule();
        modules.add(module);
        ContextBuilder.addExecutorServiceIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)1);
        Assert.assertEquals(modules.remove(0), (Object)module);
    }

    @Test
    public void testAddCredentialStoreModuleIfNotPresent() {
        ArrayList modules = Lists.newArrayList();
        CredentialStoreModule module = new CredentialStoreModule();
        modules.add(module);
        ContextBuilder.addCredentialStoreIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)1);
        Assert.assertEquals(modules.remove(0), (Object)module);
    }

    @Test
    public void testAddNone() {
        ArrayList modules = Lists.newArrayList();
        NullLoggingModule loggingModule = new NullLoggingModule();
        modules.add(loggingModule);
        HttpModule httpModule = new HttpModule();
        modules.add(httpModule);
        ContextBuilder.addHttpModuleIfNeededAndNotPresent((List)modules);
        ContextBuilder.addLoggingModuleIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)2);
        Assert.assertEquals(modules.remove(0), (Object)loggingModule);
        Assert.assertEquals(modules.remove(0), (Object)((Object)httpModule));
    }

    @Test
    public void testAddBothWhenDefault() {
        ArrayList modules = Lists.newArrayList();
        ContextBuilder.addHttpModuleIfNeededAndNotPresent((List)modules);
        ContextBuilder.addLoggingModuleIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)2);
        assert (modules.remove(0) instanceof JavaUrlHttpCommandExecutorServiceModule);
        assert (modules.remove(0) instanceof JDKLoggingModule);
    }

    @Test
    public void testAddBothWhenLive() {
        ArrayList modules = Lists.newArrayList();
        ContextBuilder.addHttpModuleIfNeededAndNotPresent((List)modules);
        ContextBuilder.addLoggingModuleIfNotPresent((List)modules);
        Assert.assertEquals((int)modules.size(), (int)2);
        assert (modules.remove(0) instanceof JavaUrlHttpCommandExecutorServiceModule);
        assert (modules.remove(0) instanceof JDKLoggingModule);
    }

    public void testBuilder() {
        AbstractModule module1 = new AbstractModule(){

            protected void configure() {
            }
        };
        AbstractModule module2 = new AbstractModule(){

            protected void configure() {
            }
        };
        ContextBuilder builder = this.testContextBuilder();
        builder.modules(Arrays.asList(module1, module2));
    }

    @ConfiguresRestClient
    static class ConfiguresClientModule
    implements Module {
        ConfiguresClientModule() {
        }

        public void configure(Binder arg0) {
        }
    }

    @ConfiguresHttpCommandExecutorService
    static class HttpModule
    extends AbstractModule {
        HttpModule() {
        }

        protected void configure() {
        }
    }
}

