/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import java.util.NoSuchElementException;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.apis.Balancer;
import org.jclouds.apis.Compute;
import org.jclouds.apis.JcloudsTestBlobStoreApiMetadata;
import org.jclouds.apis.JcloudsTestComputeApiMetadata;
import org.jclouds.apis.JcloudsTestYetAnotherComputeApiMetadata;
import org.jclouds.apis.Storage;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ApisTest")
public class ApisTest {
    private final JcloudsTestBlobStoreApiMetadata testBlobstoreApi = new JcloudsTestBlobStoreApiMetadata();
    private final JcloudsTestComputeApiMetadata testComputeApi = new JcloudsTestComputeApiMetadata();
    private final JcloudsTestYetAnotherComputeApiMetadata testYetAnotherComputeApi = new JcloudsTestYetAnotherComputeApiMetadata();

    @Test
    public void testWithId() {
        ApiMetadata apiMetadata;
        try {
            apiMetadata = Apis.withId((String)"fake-id");
            Assert.fail((String)"Looking for a api with an id that doesn't exist should throw an exception.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        apiMetadata = Apis.withId((String)this.testBlobstoreApi.getId());
        Assert.assertEquals((Object)((Object)this.testBlobstoreApi), (Object)apiMetadata);
    }

    @Test
    public void testTransformableTo() {
        Iterable apisMetadata = Apis.viewableAs(Storage.class);
        for (ApiMetadata apiMetadata : apisMetadata) {
            Assert.assertEquals((Object)((Object)this.testBlobstoreApi), (Object)apiMetadata);
        }
        apisMetadata = Apis.viewableAs(Compute.class);
        for (ApiMetadata apiMetadata : apisMetadata) {
            if (apiMetadata.getName().equals(this.testComputeApi.getName())) {
                Assert.assertEquals((Object)((Object)this.testComputeApi), (Object)apiMetadata);
                continue;
            }
            Assert.assertEquals((Object)((Object)this.testYetAnotherComputeApi), (Object)apiMetadata);
        }
        apisMetadata = Apis.viewableAs(Balancer.class);
        Assert.assertEquals((boolean)false, (boolean)apisMetadata.iterator().hasNext());
    }

    @Test
    public void testAll() {
        Iterable apisMetadata = Apis.all();
        for (ApiMetadata apiMetadata : apisMetadata) {
            if (apiMetadata.getName().equals(this.testBlobstoreApi.getName())) {
                Assert.assertEquals((Object)((Object)this.testBlobstoreApi), (Object)apiMetadata);
                continue;
            }
            if (apiMetadata.getName().equals(this.testComputeApi.getName())) {
                Assert.assertEquals((Object)((Object)this.testComputeApi), (Object)apiMetadata);
                continue;
            }
            Assert.assertEquals((Object)((Object)this.testYetAnotherComputeApi), (Object)apiMetadata);
        }
    }
}

