/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;
import org.jclouds.Context;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.logging.LoggingModules;
import org.jclouds.logging.config.LoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class BaseContextLiveTest<C extends Context> {
    protected String prefix = System.getProperty("user.name");
    protected String provider;
    protected volatile C context;
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiVersion;

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        this.identity = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".identity");
        this.credential = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".credential");
        this.endpoint = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".endpoint");
        this.apiVersion = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".api-version");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".build-version");
        return overrides;
    }

    protected String setIfTestSystemPropertyPresent(Properties overrides, String key) {
        if (System.getProperties().containsKey("test." + key)) {
            String val = System.getProperty("test." + key);
            overrides.setProperty(key, val);
            return val;
        }
        return null;
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        this.initializeContext();
    }

    protected void initializeContext() {
        Closeables.closeQuietly(this.context);
        this.context = this.createContext(this.setupProperties(), this.setupModules());
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule());
    }

    protected LoggingModule getLoggingModule() {
        return LoggingModules.firstOrJDKLoggingModule();
    }

    protected ProviderMetadata createProviderMetadata() {
        try {
            return Providers.withId((String)this.provider);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected ApiMetadata createApiMetadata() {
        try {
            return Apis.withId((String)this.provider);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected abstract TypeToken<C> contextType();

    protected C createContext(Properties props, Iterable<Module> modules) {
        return (C)this.newBuilder().modules(modules).overrides(props).build(this.contextType());
    }

    protected ContextBuilder newBuilder() {
        ProviderMetadata pm;
        if (this.provider != null) {
            try {
                return ContextBuilder.newBuilder((String)this.provider);
            }
            catch (NoSuchElementException e) {
                Logger.getAnonymousLogger().warning("provider [" + this.provider + "] is not setup as META-INF/services/org.jclouds.apis.ApiMetadata or META-INF/services/org.jclouds.providers.ProviderMetadata");
            }
        }
        ContextBuilder builder = (pm = this.createProviderMetadata()) != null ? ContextBuilder.newBuilder((ProviderMetadata)pm) : ContextBuilder.newBuilder((ApiMetadata)((ApiMetadata)ApiMetadata.class.cast(Preconditions.checkNotNull((Object)this.createApiMetadata(), (Object)"either createApiMetadata or createProviderMetadata must be overridden"))));
        return builder;
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        Closeables.closeQuietly(this.context);
    }
}

