/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.collect.AdvanceUntilEmptyIterable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="AdvanceUntilEmptyIterableTest")
public class AdvanceUntilEmptyIterableTest {
    @Test
    public void testSinglePageResultReturnsSame() {
        FluentIterable initial = FluentIterable.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"));
        Supplier nextIterable = (Supplier)EasyMock.createMock(Supplier.class);
        EasyMock.expect((Object)nextIterable.get()).andReturn((Object)initial);
        EasyMock.replay((Object[])new Object[]{nextIterable});
        AdvanceUntilEmptyIterable iterable = new AdvanceUntilEmptyIterable(nextIterable);
        Assert.assertSame((Object)iterable.get(0), (Object)initial);
        EasyMock.verify((Object[])new Object[]{nextIterable});
    }

    @Test
    public void testConcatStopsWhenEmpty() {
        Supplier nextIterable = (Supplier)EasyMock.createMock(Supplier.class);
        EasyMock.expect((Object)nextIterable.get()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar")));
        EasyMock.expect((Object)nextIterable.get()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of((Object)"boo", (Object)"baz")));
        EasyMock.expect((Object)nextIterable.get()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of((Object)"ham", (Object)"cheeze")));
        EasyMock.expect((Object)nextIterable.get()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of()));
        EasyMock.replay((Object[])new Object[]{nextIterable});
        AdvanceUntilEmptyIterable iterable = new AdvanceUntilEmptyIterable(nextIterable);
        Assert.assertEquals((Set)iterable.concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"boo", (Object)"baz", (Object)"ham", (Object)"cheeze", (Object[])new String[0]));
        EasyMock.verify((Object[])new Object[]{nextIterable});
    }
}

