/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class JsonObjectTest {
    private ParseJson<Map<String, Object>> handler;
    private Json mapper;

    @BeforeTest
    protected void setUpInjector() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});
        this.handler = (ParseJson)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<Map<String, Object>>>(){}));
        this.mapper = (Json)injector.getInstance(Json.class);
    }

    public void testHash() {
        String json = "{\"tomcat6\":{\"ssl_port\":8433}}";
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)ImmutableMap.of((Object)"tomcat6", (Object)ImmutableMap.of((Object)"ssl_port", (Object)8433.0)));
        Assert.assertEquals((String)this.mapper.toJson((Object)ImmutableMap.of((Object)"tomcat6", (Object)ImmutableMap.of((Object)"ssl_port", (Object)8433))), (String)json);
    }

    public void testList() {
        String json = "{\"list\":[8431,8433]}";
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)ImmutableMap.of((Object)"list", (Object)ImmutableList.of((Object)8431.0, (Object)8433.0)));
        Assert.assertEquals((String)this.mapper.toJson((Object)ImmutableMap.of((Object)"list", (Object)ImmutableList.of((Object)8431, (Object)8433))), (String)json);
    }

    public void testString() {
        String json = "{\"name\":\"fooy\"}";
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)"fooy");
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }

    public void testNumber() {
        String json = "{\"number\":1.0}";
        ImmutableMap map = ImmutableMap.of((Object)"number", (Object)1.0);
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }
}

