/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.inject.Module;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.jclouds.http.BaseJettyTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(sequential=true)
public class BackoffLimitedRetryJavaTest
extends BaseJettyTest {
    private int beginToFailOnRequestNumber = 0;
    private int endFailuresOnRequestNumber = 0;
    private int requestCount = 0;

    @Override
    protected void addConnectionProperties(Properties props) {
    }

    @Override
    protected Module createConnectionModule() {
        return new JavaUrlHttpCommandExecutorServiceModule();
    }

    @Override
    protected boolean failEveryTenRequests(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean shouldFail;
        ++this.requestCount;
        boolean bl = shouldFail = this.requestCount >= this.beginToFailOnRequestNumber && this.requestCount <= this.endFailuresOnRequestNumber;
        if (shouldFail) {
            response.sendError(500);
            ((Request)request).setHandled(true);
            return true;
        }
        return false;
    }

    protected String submitGetRequest() throws InterruptedException, ExecutionException {
        return this.client.download("");
    }

    @Test
    public void testNoRetriesSuccessful() throws InterruptedException, ExecutionException {
        this.beginToFailOnRequestNumber = 1;
        this.endFailuresOnRequestNumber = 1;
        this.requestCount = 0;
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test
    public void testSingleRetrySuccessful() throws InterruptedException, ExecutionException {
        this.beginToFailOnRequestNumber = 0;
        this.endFailuresOnRequestNumber = 1;
        this.requestCount = 0;
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test
    public void testMaximumRetriesSuccessful() throws InterruptedException, ExecutionException {
        this.beginToFailOnRequestNumber = 0;
        this.endFailuresOnRequestNumber = 5;
        this.requestCount = 0;
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test
    public void testMaximumRetriesExceeded() throws InterruptedException, ExecutionException {
        this.beginToFailOnRequestNumber = 0;
        this.endFailuresOnRequestNumber = 6;
        this.requestCount = 0;
        try {
            this.submitGetRequest();
            Assert.fail((String)("Request should not succeed within " + this.endFailuresOnRequestNumber + " requests"));
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)500);
        }
    }

    @Test
    public void testInterleavedSuccessesAndFailures() throws InterruptedException, ExecutionException {
        this.beginToFailOnRequestNumber = 3;
        this.endFailuresOnRequestNumber = 8;
        this.requestCount = 0;
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
        try {
            this.submitGetRequest();
            Assert.fail((String)("Third request should not succeed by attempt number " + this.requestCount));
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)500);
        }
        Assert.assertEquals((String)this.submitGetRequest().trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }
}

