/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jclouds.ContextBuilder;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.io.ByteSources;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.util.Strings2;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public abstract class BaseJettyTest {
    protected static final String XML = "<foo><bar>whoppers</bar></foo>";
    protected static final String XML2 = "<foo><bar>chubbs</bar></foo>";
    protected Server server = null;
    protected IntegrationTestClient client;
    protected Injector injector;
    private AtomicInteger cycle = new AtomicInteger(0);
    private Server server2;
    protected int testPort;
    protected String md5;
    static final Pattern actionPattern = Pattern.compile("/objects/(.*)/action/([a-z]*);?(.*)");

    @BeforeClass
    @Parameters(value={"test-jetty-port"})
    public void setUpJetty(final @Optional(value="8123") int testPort) throws Exception {
        this.testPort = testPort;
        final InputSupplier<InputStream> oneHundredOneConstitutions = BaseJettyTest.getTestDataSupplier();
        this.md5 = BaseEncoding.base64().encode(ByteSources.asByteSource((InputStream)((InputStream)oneHundredOneConstitutions.getInput())).hash(Hashing.md5()).asBytes());
        AbstractHandler server1Handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (BaseJettyTest.this.failIfNoContentLength(request, response)) {
                    return;
                }
                if (target.indexOf("sleep") > 0) {
                    Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    response.setContentType("text/xml");
                    response.setStatus(200);
                } else if (target.indexOf("redirect") > 0) {
                    Strings2.toStringAndClose((InputStream)request.getInputStream());
                    response.sendRedirect("https://localhost:" + (testPort + 1) + "/");
                } else if (target.indexOf("101constitutions") > 0) {
                    response.setContentType("text/plain");
                    response.setHeader("Content-MD5", BaseJettyTest.this.md5);
                    response.setStatus(200);
                    ByteStreams.copy((InputSupplier)oneHundredOneConstitutions, (OutputStream)response.getOutputStream());
                } else if (request.getMethod().equals("PUT")) {
                    if (request.getContentLength() > 0) {
                        response.setStatus(200);
                        response.getWriter().println(Strings2.toStringAndClose((InputStream)request.getInputStream()) + "PUT");
                    } else {
                        response.setStatus(200);
                    }
                } else if (request.getMethod().equals("POST")) {
                    if (request.getContentLength() < 10240 && BaseJettyTest.this.redirectEveryTwentyRequests(request, response)) {
                        return;
                    }
                    if (BaseJettyTest.this.failEveryTenRequests(request, response)) {
                        return;
                    }
                    if (request.getContentLength() > 0) {
                        BaseJettyTest.handlePost(request, response);
                    } else {
                        BaseJettyTest.this.handleAction(request, response);
                    }
                } else if (request.getHeader("range") != null) {
                    response.sendError(404, "no content");
                } else if (request.getHeader("test") != null) {
                    response.setContentType("text/plain");
                    response.setStatus(200);
                    response.getWriter().println("test");
                } else if (request.getMethod().equals("HEAD")) {
                    response.setContentType("text/xml");
                    response.setStatus(200);
                } else {
                    if (BaseJettyTest.this.failEveryTenRequests(request, response)) {
                        return;
                    }
                    response.setContentType("text/xml");
                    response.setStatus(200);
                    response.getWriter().println(BaseJettyTest.XML);
                }
                ((Request)Request.class.cast(request)).setHandled(true);
            }
        };
        this.server = new Server(testPort);
        this.server.setHandler((Handler)server1Handler);
        this.server.start();
        this.setupAndStartSSLServer(testPort);
        Properties properties = new Properties();
        this.addConnectionProperties(properties);
        this.client = (IntegrationTestClient)BaseJettyTest.newBuilder(testPort, properties, this.createConnectionModule()).buildApi(IntegrationTestClient.class);
        assert (this.client != null);
        assert (this.client.newStringBuilder() != null);
    }

    private static void handlePost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletInputStream body = request.getInputStream();
        try {
            if (request.getHeader("Content-MD5") != null) {
                String realMd5FromRequest;
                String expectedMd5 = request.getHeader("Content-MD5");
                boolean matched = expectedMd5.equals(realMd5FromRequest = BaseEncoding.base64().encode(ByteSources.asByteSource((InputStream)body).hash(Hashing.md5()).asBytes()));
                if (matched) {
                    response.setStatus(200);
                    response.addHeader("x-Content-MD5", realMd5FromRequest);
                } else {
                    response.sendError(500, "didn't match");
                }
            } else {
                String responseString = request.getContentLength() < 10240 ? Strings2.toStringAndClose((InputStream)body) + "POST" : "POST";
                body = null;
                for (String header : new String[]{"Content-Disposition", "Content-Language", "Content-Encoding"}) {
                    if (request.getHeader(header) == null) continue;
                    response.addHeader("x-" + header, request.getHeader(header));
                }
                response.setStatus(200);
                response.getWriter().println(responseString);
            }
            ((Request)Request.class.cast(request)).setHandled(true);
        }
        catch (IOException e) {
            Closeables.closeQuietly((Closeable)body);
            response.sendError(500, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    protected void setupAndStartSSLServer(int testPort) throws Exception {
        AbstractHandler server2Handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (request.getMethod().equals("PUT")) {
                    if (request.getContentLength() > 0) {
                        response.setStatus(200);
                        String text = Strings2.toStringAndClose((InputStream)request.getInputStream());
                        response.getWriter().println(text + "PUTREDIRECT");
                    }
                } else if (request.getMethod().equals("POST")) {
                    if (request.getContentLength() > 0) {
                        BaseJettyTest.handlePost(request, response);
                    } else {
                        BaseJettyTest.this.handleAction(request, response);
                    }
                } else if (request.getMethod().equals("HEAD")) {
                    response.setContentType("text/xml");
                    response.setStatus(200);
                } else {
                    response.setContentType("text/xml");
                    response.setStatus(200);
                    response.getWriter().println(BaseJettyTest.XML2);
                }
                ((Request)Request.class.cast(request)).setHandled(true);
            }
        };
        this.server2 = new Server();
        this.server2.setHandler((Handler)server2Handler);
        SslSelectChannelConnector ssl_connector = new SslSelectChannelConnector();
        ssl_connector.setPort(testPort + 1);
        ssl_connector.setMaxIdleTime(30000);
        SslContextFactory ssl = ssl_connector.getSslContextFactory();
        ssl.setKeyStorePath("src/test/resources/test.jks");
        ssl.setKeyStorePassword("jclouds");
        ssl.setTrustStore("src/test/resources/test.jks");
        ssl.setTrustStorePassword("jclouds");
        this.server2.setConnectors(new Connector[]{ssl_connector});
        this.server2.start();
    }

    public static InputSupplier<InputStream> getTestDataSupplier() throws IOException {
        byte[] oneConstitution = ByteStreams.toByteArray((InputStream)new GZIPInputStream(BaseJettyTest.class.getResourceAsStream("/const.txt.gz")));
        InputSupplier constitutionSupplier = ByteStreams.newInputStreamSupplier((byte[])oneConstitution);
        InputSupplier temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{constitutionSupplier});
        for (int i = 0; i < 100; ++i) {
            temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{temp, constitutionSupplier});
        }
        return temp;
    }

    public static ContextBuilder newBuilder(int testPort, Properties properties, Module ... connectionModules) {
        properties.setProperty("jclouds.trust-all-certs", "true");
        properties.setProperty("jclouds.relax-hostname", "true");
        return ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)("http://localhost:" + testPort))).modules((Iterable)ImmutableSet.copyOf((Object[])connectionModules)).overrides(properties);
    }

    @AfterClass
    public void tearDownJetty() throws Exception {
        Closeables.closeQuietly((Closeable)this.client);
        if (this.server2 != null) {
            this.server2.stop();
        }
        this.server.stop();
    }

    protected abstract void addConnectionProperties(Properties var1);

    protected abstract Module createConnectionModule();

    protected boolean failEveryTenRequests(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.cycle.incrementAndGet() % 10 == 0) {
            response.sendError(500, "unlucky 10");
            ((Request)Request.class.cast(request)).setHandled(true);
            return true;
        }
        return false;
    }

    protected boolean redirectEveryTwentyRequests(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.cycle.incrementAndGet() % 20 == 0) {
            response.sendRedirect("http://localhost:" + (this.testPort + 1) + "/");
            ((Request)Request.class.cast(request)).setHandled(true);
            return true;
        }
        return false;
    }

    protected boolean failIfNoContentLength(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LinkedHashMultimap realHeaders = LinkedHashMultimap.create();
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = ((String)headers.nextElement()).toString();
            Enumeration values = request.getHeaders(header);
            while (values.hasMoreElements()) {
                realHeaders.put((Object)header, (Object)((String)values.nextElement()).toString());
            }
        }
        if (realHeaders.get((Object)"Content-Length") == null) {
            response.getWriter().println("no content length!");
            response.getWriter().println(realHeaders.toString());
            response.sendError(500, "no content length!");
            ((Request)Request.class.cast(request)).setHandled(true);
            return true;
        }
        return false;
    }

    private void handleAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher = actionPattern.matcher(request.getRequestURI());
        boolean matchFound = matcher.find();
        if (matchFound) {
            String objectId = matcher.group(1);
            String action = matcher.group(2);
            ImmutableMap.Builder options = ImmutableMap.builder();
            if (matcher.groupCount() == 3) {
                options.putAll(Splitter.on((char)';').withKeyValueSeparator("=").split((CharSequence)matcher.group(3)));
            }
            response.setStatus(200);
            response.getWriter().println(objectId + "->" + action + ":" + options.build());
        } else {
            response.sendError(500, "no content");
        }
    }
}

