/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="http.HttpRequestTest")
public class HttpRequestTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testConstructorHostNull() throws Exception {
        URI uri = URI.create("http://adriancole.compute1138eu.s3-external-3.amazonaws.com:-1");
        assert (uri.getHost() == null) : "test requires something to produce a uri with a null hostname";
        HttpRequest.builder().method("GET").endpoint(uri).build();
    }

    public void testReplaceQueryParams() throws Exception {
        URI uri = URI.create("http://goo.com:443?header=value1");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(uri).build();
        Assert.assertEquals((Object)request.toBuilder().replaceQueryParam("header", new String[]{"foo"}).build(), (Object)HttpRequest.builder().method("GET").endpoint("http://goo.com:443?header=foo").build());
    }

    public void testEncodesOnlyOnce() throws Exception {
        URI uri = URI.create("http://goo.com:443?header=value1");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(uri).build();
        Assert.assertEquals((Object)request.toBuilder().replaceQueryParam("header", new String[]{"hello?"}).build(), (Object)HttpRequest.builder().method("GET").endpoint("http://goo.com:443?header=hello%3F").build());
    }

    public void testAddFormParamAddsAnotherValue() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").payload("foo=bar")).build();
        StringPayload payload = Payloads.newStringPayload((String)"foo=bar&foo=baz");
        payload.getContentMetadata().setContentType(MediaType.FORM_DATA.toString());
        Assert.assertEquals((Object)request.toBuilder().addFormParams((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"baz")).build(), (Object)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").payload((Payload)payload)).build());
    }

    public void testAddingBase64EncodedQueryParamCausingPlusToUrlEncodedSpaceConversion() {
        String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        URI uri = URI.create("http://goo.com:443?header1=valueWithUrlEncoded%2BPlus");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(uri).addQueryParam("header2", new String[]{base64Chars}).build();
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://goo.com:443?header1=valueWithUrlEncoded%20Plus&header2=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%20/%3D HTTP/1.1");
    }

    public void testAddBase64AndUrlEncodedQueryParams() {
        String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%2B%2F%3D";
        URI uri = URI.create("http://goo.com:443?header1=" + base64Chars);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(uri).addQueryParam("header2", new String[]{base64Chars}).build();
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://goo.com:443?header1=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%20/%3D&header2=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%2B/%3D HTTP/1.1");
    }

    public void testAddBase64EncodedQueryParamWithNewlines() {
        String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n0123456789%2B/=";
        URI uri = URI.create("http://goo.com:443?header1=value1");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(uri).addQueryParam("header2", new String[]{base64Chars}).build();
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://goo.com:443?header1=value1&header2=ABCDEFGHIJKLMNOPQRSTUVWXYZ%0Aabcdefghijklmnopqrstuvwxyz%0A0123456789%2B/%3D HTTP/1.1");
    }
}

