/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.io.Payload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReturnStringIf200Test {
    @Test
    public void testNullWhenNoContentOn200() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ReturnStringIf2xx function = new ReturnStringIf2xx();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        EasyMock.expect((Object)response.getPayload()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        assert (function.apply((Object)response) == null);
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }

    @Test
    public void testExceptionWhenIOExceptionOn200() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        Payload payload;
        HttpResponse response;
        block2: {
            ReturnStringIf2xx function = new ReturnStringIf2xx();
            response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
            payload = (Payload)EasyMock.createMock(Payload.class);
            EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
            RuntimeException exception = new RuntimeException("bad");
            EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
            EasyMock.expect((Object)payload.getInput()).andThrow((Throwable)exception);
            payload.release();
            EasyMock.replay((Object[])new Object[]{payload});
            EasyMock.replay((Object[])new Object[]{response});
            try {
                function.apply((Object)response);
            }
            catch (Exception e) {
                if ($assertionsDisabled || e.equals(exception)) break block2;
                throw new AssertionError();
            }
        }
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }

    @Test
    public void testResponseOk() throws Exception {
        ReturnStringIf2xx function = new ReturnStringIf2xx();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        EasyMock.expect((Object)payload.getInput()).andReturn((Object)Strings2.toInputStream((String)"hello"));
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((String)((String)function.apply((Object)response)), (String)"hello");
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }
}

