/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.handlers.CloseContentAndSetExceptionErrorHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DelegatingErrorHandlerTest {
    public void testDefaultInjection() {
        DelegatingErrorHandler handler = (DelegatingErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(DelegatingErrorHandler.class);
        Assert.assertEquals(handler.getClientErrorHandler().getClass(), CloseContentAndSetExceptionErrorHandler.class);
        Assert.assertEquals(handler.getServerErrorHandler().getClass(), CloseContentAndSetExceptionErrorHandler.class);
        Assert.assertEquals(handler.getRedirectionHandler().getClass(), CloseContentAndSetExceptionErrorHandler.class);
    }

    public void testClientHandlerInjection() {
        DelegatingErrorHandler handler = (DelegatingErrorHandler)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DelegatingErrorHandler.class);
            }
        }}).getInstance(DelegatingErrorHandler.class);
        Assert.assertEquals(handler.getClientErrorHandler().getClass(), DelegatingErrorHandler.class);
        Assert.assertEquals(handler.getServerErrorHandler().getClass(), CloseContentAndSetExceptionErrorHandler.class);
        Assert.assertEquals(handler.getRedirectionHandler().getClass(), CloseContentAndSetExceptionErrorHandler.class);
    }
}

