/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ByteSources;
import org.jclouds.logging.Logger;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true)
public class WireLiveTest {
    private static final String sysHttpStreamUrl = System.getProperty("jclouds.wire.httpstream.url");
    private static final String sysHttpStreamMd5 = System.getProperty("jclouds.wire.httpstream.md5");

    public static HttpWire setUp() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    public HttpWire setUpSynch() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    @Test(groups={"live"})
    public void testRemoteInputStream() throws Exception {
        try {
            URL url = new URL((String)Preconditions.checkNotNull((Object)sysHttpStreamUrl, (Object)"sysHttpStreamUrl"));
            URLConnection connection = url.openConnection();
            HttpWire wire = WireLiveTest.setUp();
            InputStream in = wire.input(connection.getInputStream());
            byte[] compare = ByteSources.asByteSource((InputStream)in).hash(Hashing.md5()).asBytes();
            Thread.sleep(100L);
            Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(compare), (String)((String)Preconditions.checkNotNull((Object)sysHttpStreamMd5, (Object)sysHttpStreamMd5)));
            Assert.assertEquals((int)((BufferLogger)wire.getWireLog()).buff.toString().getBytes().length, (int)3331484);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test(groups={"live"}, enabled=false)
    public void testCopyRemoteInputStream() throws Exception {
        URL url = new URL((String)Preconditions.checkNotNull((Object)sysHttpStreamUrl, (Object)"sysHttpStreamUrl"));
        URLConnection connection = url.openConnection();
        ConnectionTester callable = new ConnectionTester(connection.getInputStream());
        Future<Void> result = Executors.newCachedThreadPool().submit(callable);
        result.get(30L, TimeUnit.SECONDS);
    }

    @Test(groups={"live"})
    public void testRemoteInputStreamSynch() throws Exception {
        try {
            URL url = new URL((String)Preconditions.checkNotNull((Object)sysHttpStreamUrl, (Object)"sysHttpStreamUrl"));
            URLConnection connection = url.openConnection();
            HttpWire wire = this.setUpSynch();
            InputStream in = wire.input(connection.getInputStream());
            byte[] compare = ByteSources.asByteSource((InputStream)in).hash(Hashing.md5()).asBytes();
            Thread.sleep(100L);
            Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(compare), (String)((String)Preconditions.checkNotNull((Object)sysHttpStreamMd5, (Object)sysHttpStreamMd5)));
            Assert.assertEquals((int)((BufferLogger)wire.getWireLog()).buff.toString().getBytes().length, (int)3331484);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    static class BufferLogger
    implements Logger {
        StringBuilder buff = new StringBuilder();

        BufferLogger() {
        }

        public void debug(String message, Object ... args) {
            this.buff.append(message);
        }

        public void error(String message, Object ... args) {
        }

        public void error(Throwable throwable, String message, Object ... args) {
        }

        public String getCategory() {
            return null;
        }

        public void info(String message, Object ... args) {
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void trace(String message, Object ... args) {
        }

        public void warn(String message, Object ... args) {
        }

        public void warn(Throwable throwable, String message, Object ... args) {
        }
    }

    private static class ConnectionTester
    implements Callable<Void> {
        private final InputStream fromServer;

        private ConnectionTester(InputStream fromServer) {
            this.fromServer = fromServer;
        }

        @Override
        public Void call() throws Exception {
            HttpWire wire = WireLiveTest.setUp();
            InputStream in = wire.input(this.fromServer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            byte[] compare = Hashing.md5().hashBytes(out.toByteArray()).asBytes();
            Thread.sleep(100L);
            Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(compare), (String)((String)Preconditions.checkNotNull((Object)sysHttpStreamMd5, (Object)sysHttpStreamMd5)));
            Assert.assertEquals((int)((BufferLogger)wire.getWireLog()).buff.toString().getBytes().length, (int)3331484);
            return null;
        }
    }
}

