/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.easymock.EasyMock;
import org.jclouds.Context;
import org.jclouds.domain.Credentials;
import org.jclouds.internal.BaseView;
import org.jclouds.internal.ContextImpl;
import org.jclouds.lifecycle.Closer;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.Utils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BaseViewTest")
public class BaseViewTest {
    static Supplier<Credentials> creds = Suppliers.ofInstance((Object)new Credentials("identity", null));

    public void testWaterTurnedIntoWine() {
        Wine wine = new Wine();
        Assert.assertEquals((Object)wine.getBackendType(), (Object)Reflection2.typeToken(Water.class));
        Assert.assertEquals(((Object)((Object)((Water)wine.unwrap(Reflection2.typeToken(Water.class))))).getClass(), Water.class);
        Assert.assertEquals(wine.unwrap().getClass(), Water.class);
    }

    public void testPeanutButterDidntTurnIntoWine() {
        Wine wine = new Wine();
        Assert.assertNotEquals((Object)wine.getBackendType(), (Object)Reflection2.typeToken(PeanutButter.class));
        try {
            wine.unwrap(Reflection2.typeToken(PeanutButter.class));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"backend type: org.jclouds.internal.BaseViewTest$Water not assignable from org.jclouds.internal.BaseViewTest$PeanutButter");
        }
    }

    private static class Wine
    extends BaseView {
        protected Wine() {
            super((Context)new Water(), Reflection2.typeToken(Water.class));
        }
    }

    private static class PeanutButter
    extends ContextImpl {
        protected PeanutButter() {
            super("peanutbutter", (ProviderMetadata)EasyMock.createMock(ProviderMetadata.class), creds, (Utils)EasyMock.createMock(Utils.class), (Closer)EasyMock.createMock(Closer.class));
        }

        public void close() {
        }
    }

    private static class Water
    extends ContextImpl {
        protected Water() {
            super("water", (ProviderMetadata)EasyMock.createMock(ProviderMetadata.class), creds, (Utils)EasyMock.createMock(Utils.class), (Closer)EasyMock.createMock(Closer.class));
        }

        public void close() {
        }
    }
}

