/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import javax.inject.Qualifier;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.TransformerForRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseParserTest<T, G> {
    protected Function<HttpResponse, T> parser(Injector i) {
        try {
            return ((TransformerForRequest)i.createChildInjector(new Module[]{new SaxParserModule()}).getInstance(TransformerForRequest.class)).getTransformerForMethod(Invocation.create((Invokable)Reflection2.method(this.getClass(), (String)"expected", (Class[])new Class[0]), (List)ImmutableList.of()), i);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void test() {
        T expects = this.expected();
        Function<HttpResponse, T> parser = this.parser(this.injector());
        Object response = parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(this.payload())).build());
        this.compare(expects, response);
    }

    protected Payload payload() {
        return Payloads.newInputStreamPayload((InputStream)this.getClass().getResourceAsStream(this.resource()));
    }

    public void compare(T expects, T response) {
        Assert.assertEquals((String)response.toString(), (String)expects.toString());
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new GsonModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
                super.configure();
            }
        }});
    }

    protected String resource() {
        throw new IllegalStateException("please define resource such as \"/testaddresses.json\"");
    }

    public abstract T expected();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface Nested {
    }
}

