/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import org.jclouds.json.internal.OptionalTypeAdapterFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="OptionalTypeAdapterFactoryTest")
public class OptionalTypeAdapterFactoryTest {
    private Gson gsonAdapter = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).create();

    public void testValuePresent() {
        String json = "{\"value\":\"a test string!\"}";
        SimpleBean expected = new SimpleBean((Optional<String>)Optional.of((Object)"a test string!"), null);
        SimpleBean actual = (SimpleBean)this.gsonAdapter.fromJson(json, SimpleBean.class);
        Assert.assertTrue((boolean)actual.value.isPresent());
        Assert.assertEquals((String)((String)actual.getValue().get()), (String)"a test string!");
        Assert.assertNull((Object)actual.getSomeOtherValue());
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)actual), (String)json);
    }

    public void testValueAbsent() {
        String json = "{\"someOtherValue\":\"testvalue\"}";
        SimpleBean expected = new SimpleBean((Optional<String>)Optional.absent(), "testvalue");
        SimpleBean actual = (SimpleBean)this.gsonAdapter.fromJson(json, SimpleBean.class);
        Assert.assertFalse((boolean)actual.value.isPresent());
        Assert.assertEquals((String)actual.getSomeOtherValue(), (String)"testvalue");
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)actual), (String)json);
    }

    public void testValueNull() {
        String json = "{\"value\":null}";
        SimpleBean expected = new SimpleBean((Optional<String>)Optional.absent(), null);
        SimpleBean actual = (SimpleBean)this.gsonAdapter.fromJson(json, SimpleBean.class);
        Assert.assertFalse((boolean)actual.value.isPresent());
        Assert.assertNull((Object)actual.getSomeOtherValue());
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((String)this.gsonAdapter.toJson((Object)actual), (String)"{}");
    }

    static class SimpleBean {
        private final Optional<String> value;
        private final String someOtherValue;

        public SimpleBean(Optional<String> value, String someOtherValue) {
            this.value = value;
            this.someOtherValue = someOtherValue;
        }

        private SimpleBean() {
            this.value = Optional.absent();
            this.someOtherValue = null;
        }

        public Optional<String> getValue() {
            return this.value;
        }

        public String getSomeOtherValue() {
            return this.someOtherValue;
        }

        public boolean equals(Object other) {
            SimpleBean that = (SimpleBean)SimpleBean.class.cast(other);
            return Objects.equal(this.value, that.value) && Objects.equal((Object)this.someOtherValue, (Object)that.someOtherValue);
        }
    }
}

