/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.config;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.easymock.EasyMock;
import org.jclouds.logging.Logger;
import org.jclouds.logging.config.BindLoggersAnnotatedWithResource;
import org.jclouds.logging.jdk.JDKLogger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class BindLoggersAnnotatedWithResourceTest {
    private BindLoggersAnnotatedWithResource blawr;

    @BeforeMethod
    void createBlawr() {
        this.blawr = new BindLoggersAnnotatedWithResource((Logger.LoggerFactory)new JDKLogger.JDKLoggerFactory());
    }

    @Test
    void testHear() {
        Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), (TypeListener)BindLoggersAnnotatedWithResourceTest.this.blawr);
            }
        }});
        Assert.assertEquals((String)((A)i.getInstance(A.class)).logger.getCategory(), (String)(this.getClass().getName() + "$A"));
        Assert.assertEquals((String)((B)i.getInstance(B.class)).logger.getCategory(), (String)(this.getClass().getName() + "$B"));
        Assert.assertEquals((String)((B)i.getInstance(B.class)).blogger.getCategory(), (String)"blogger");
    }

    @Test
    public void testAssignLoggerToField() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Logger logger = (Logger)EasyMock.createMock(Logger.class);
        A a = new A();
        Field field = A.class.getDeclaredField("logger");
        BindLoggersAnnotatedWithResource.AssignLoggerToField assigner = new BindLoggersAnnotatedWithResource.AssignLoggerToField(logger, field);
        assigner.afterInjection((Object)a);
        assert (field.get(a).equals(logger));
    }

    @Test
    public void testLoggerFieldsAnnotatedWithResource() throws SecurityException, NoSuchFieldException {
        BindLoggersAnnotatedWithResource.LoggerFieldsAnnotatedWithResource predicate = new BindLoggersAnnotatedWithResource.LoggerFieldsAnnotatedWithResource();
        assert (predicate.apply(A.class.getDeclaredField("logger")));
    }

    @Test
    public void testLoggerFieldsAnnotatedWithInjectReturnsNull() throws SecurityException, NoSuchFieldException {
        BindLoggersAnnotatedWithResource.LoggerFieldsAnnotatedWithResource predicate = new BindLoggersAnnotatedWithResource.LoggerFieldsAnnotatedWithResource();
        assert (!predicate.apply(C.class.getDeclaredField("logger")));
    }

    @Test
    public void testGetLoggerFieldsAnnotatedWithResourceNoLogger() {
        Set fields = this.blawr.getLoggerFieldsAnnotatedWithResource(this.getClass());
        Assert.assertEquals((int)fields.size(), (int)0);
    }

    @Test
    public void testGetLoggerFieldsAnnotatedWithResourceOneLogger() {
        Set fields = this.blawr.getLoggerFieldsAnnotatedWithResource(A.class);
        Assert.assertEquals((int)fields.size(), (int)1);
    }

    @Test
    public void testGetLoggerFieldsAnnotatedWithResourceTwoLoggers() {
        Set fields = this.blawr.getLoggerFieldsAnnotatedWithResource(D.class);
        Assert.assertEquals((int)fields.size(), (int)2);
    }

    public static class D {
        @Resource
        private Logger logger = Logger.NULL;
        @Resource
        private Logger blogger;
    }

    public static class C {
        @Inject
        private Logger logger = Logger.NULL;
    }

    private static class B {
        @Resource
        private Logger logger = Logger.NULL;
        @Resource
        @Named(value="blogger")
        private Logger blogger = Logger.NULL;

        private B() {
        }
    }

    public static class A {
        @Resource
        private Logger logger = Logger.NULL;
    }
}

