/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.JcloudsTestBlobStoreApiMetadata;
import org.jclouds.apis.JcloudsTestComputeApiMetadata;
import org.jclouds.apis.JcloudsTestYetAnotherComputeApiMetadata;
import org.jclouds.osgi.ApiListener;
import org.jclouds.osgi.MetadataBundleListener;
import org.jclouds.osgi.ProviderListener;
import org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata;
import org.jclouds.providers.JcloudsTestComputeProviderMetadata;
import org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataBundleListenerTest {
    @Test
    public void testSanity() throws MalformedURLException, ClassNotFoundException {
        ClassLoader loader = this.createIsolatedClassLoader();
        Assert.assertFalse((boolean)ProviderMetadata.class.isAssignableFrom(loader.loadClass("org.jclouds.providers.JcloudsTestComputeProviderMetadata")));
    }

    @Test
    public void testGetProviderMetadata() throws Exception {
        MetadataBundleListener listener = new MetadataBundleListener();
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.providers.ProviderMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata")).andReturn(JcloudsTestBlobStoreProviderMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestComputeProviderMetadata")).andReturn(JcloudsTestComputeProviderMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata")).andReturn(JcloudsTestYetAnotherComputeProviderMetadata.class).anyTimes();
        EasyMock.replay((Object[])new Object[]{bundle});
        ArrayList providerMetadataList = Lists.newArrayList((Iterable)listener.listProviderMetadata(bundle));
        Assert.assertNotNull((Object)providerMetadataList);
        Assert.assertEquals((int)3, (int)providerMetadataList.size());
        Assert.assertTrue((boolean)providerMetadataList.contains((Object)new JcloudsTestBlobStoreProviderMetadata()));
        Assert.assertTrue((boolean)providerMetadataList.contains((Object)new JcloudsTestComputeProviderMetadata()));
        Assert.assertTrue((boolean)providerMetadataList.contains((Object)new JcloudsTestYetAnotherComputeProviderMetadata()));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testProviderListener() throws Exception {
        MetadataBundleListener listener = new MetadataBundleListener();
        ProviderListener providerListener = (ProviderListener)EasyMock.createMock(ProviderListener.class);
        listener.addProviderListener(providerListener);
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getBundleId()).andReturn((Object)10L).anyTimes();
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.providers.ProviderMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.apis.ApiMetadata")).andReturn(null).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata")).andReturn(JcloudsTestBlobStoreProviderMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestComputeProviderMetadata")).andReturn(JcloudsTestComputeProviderMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata")).andReturn(JcloudsTestYetAnotherComputeProviderMetadata.class).anyTimes();
        providerListener.added((ProviderMetadata)EasyMock.anyObject(JcloudsTestBlobStoreProviderMetadata.class));
        EasyMock.expectLastCall().times(1);
        providerListener.added((ProviderMetadata)EasyMock.anyObject(JcloudsTestComputeProviderMetadata.class));
        EasyMock.expectLastCall().times(1);
        providerListener.added((ProviderMetadata)EasyMock.anyObject(JcloudsTestYetAnotherComputeProviderMetadata.class));
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{bundle, providerListener});
        BundleEvent event = new BundleEvent(2, bundle);
        listener.bundleChanged(event);
        EasyMock.verify((Object[])new Object[]{bundle, providerListener});
    }

    @Test
    public void testGetProviderMetadataFromMultipleClassLoaders() throws Exception {
        ClassLoader isolatedClassLoader = this.createIsolatedClassLoader();
        MetadataBundleListener listener = new MetadataBundleListener();
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.providers.ProviderMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestBlobStoreProviderMetadata")).andReturn(isolatedClassLoader.loadClass(JcloudsTestBlobStoreProviderMetadata.class.getName())).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestComputeProviderMetadata")).andReturn(JcloudsTestComputeProviderMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.providers.JcloudsTestYetAnotherComputeProviderMetadata")).andReturn(JcloudsTestYetAnotherComputeProviderMetadata.class).anyTimes();
        EasyMock.replay((Object[])new Object[]{bundle});
        ArrayList providerMetadataList = Lists.newArrayList((Iterable)listener.listProviderMetadata(bundle));
        Assert.assertNotNull((Object)providerMetadataList);
        Assert.assertEquals((int)2, (int)providerMetadataList.size());
        Assert.assertFalse((boolean)providerMetadataList.contains((Object)new JcloudsTestBlobStoreProviderMetadata()));
        Assert.assertTrue((boolean)providerMetadataList.contains((Object)new JcloudsTestComputeProviderMetadata()));
        Assert.assertTrue((boolean)providerMetadataList.contains((Object)new JcloudsTestYetAnotherComputeProviderMetadata()));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testGetApiMetadata() throws Exception {
        MetadataBundleListener listener = new MetadataBundleListener();
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.apis.ApiMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.apis.ApiMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestBlobStoreApiMetadata")).andReturn(JcloudsTestBlobStoreApiMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestComputeApiMetadata")).andReturn(JcloudsTestComputeApiMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestYetAnotherComputeApiMetadata")).andReturn(JcloudsTestYetAnotherComputeApiMetadata.class).anyTimes();
        EasyMock.replay((Object[])new Object[]{bundle});
        ArrayList apiMetadataList = Lists.newArrayList((Iterable)listener.listApiMetadata(bundle));
        Assert.assertNotNull((Object)apiMetadataList);
        Assert.assertEquals((int)3, (int)apiMetadataList.size());
        Assert.assertTrue((boolean)apiMetadataList.contains((Object)new JcloudsTestBlobStoreApiMetadata()));
        Assert.assertTrue((boolean)apiMetadataList.contains((Object)new JcloudsTestComputeApiMetadata()));
        Assert.assertTrue((boolean)apiMetadataList.contains((Object)new JcloudsTestYetAnotherComputeApiMetadata()));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    @Test
    public void testApiListener() throws Exception {
        MetadataBundleListener listener = new MetadataBundleListener();
        ApiListener apiListener = (ApiListener)EasyMock.createMock(ApiListener.class);
        listener.addApiListenerListener(apiListener);
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getBundleId()).andReturn((Object)10L).anyTimes();
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata")).andReturn(null).anyTimes();
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.apis.ApiMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.apis.ApiMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestBlobStoreApiMetadata")).andReturn(JcloudsTestBlobStoreApiMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestComputeApiMetadata")).andReturn(JcloudsTestComputeApiMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestYetAnotherComputeApiMetadata")).andReturn(JcloudsTestYetAnotherComputeApiMetadata.class).anyTimes();
        apiListener.added((ApiMetadata)EasyMock.anyObject(JcloudsTestBlobStoreApiMetadata.class));
        EasyMock.expectLastCall().times(1);
        apiListener.added((ApiMetadata)EasyMock.anyObject(JcloudsTestBlobStoreApiMetadata.class));
        EasyMock.expectLastCall().times(1);
        apiListener.added((ApiMetadata)EasyMock.anyObject(JcloudsTestComputeApiMetadata.class));
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{bundle, apiListener});
        BundleEvent event = new BundleEvent(2, bundle);
        listener.bundleChanged(event);
        EasyMock.verify((Object[])new Object[]{bundle, apiListener});
    }

    @Test
    public void testGetApiMetadataFromMultipleClassLoaders() throws Exception {
        ClassLoader isolatedClassLoader = this.createIsolatedClassLoader();
        MetadataBundleListener listener = new MetadataBundleListener();
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getEntry("/META-INF/services/org.jclouds.apis.ApiMetadata")).andReturn((Object)this.getClass().getResource("/META-INF/services/org.jclouds.apis.ApiMetadata")).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestBlobStoreApiMetadata")).andReturn(isolatedClassLoader.loadClass(JcloudsTestBlobStoreApiMetadata.class.getName())).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestComputeApiMetadata")).andReturn(JcloudsTestComputeApiMetadata.class).anyTimes();
        EasyMock.expect((Object)bundle.loadClass("org.jclouds.apis.JcloudsTestYetAnotherComputeApiMetadata")).andReturn(JcloudsTestYetAnotherComputeApiMetadata.class).anyTimes();
        EasyMock.replay((Object[])new Object[]{bundle});
        ArrayList apiMetadataList = Lists.newArrayList((Iterable)listener.listApiMetadata(bundle));
        Assert.assertNotNull((Object)apiMetadataList);
        Assert.assertEquals((int)2, (int)apiMetadataList.size());
        Assert.assertFalse((boolean)apiMetadataList.contains((Object)new JcloudsTestBlobStoreApiMetadata()));
        Assert.assertTrue((boolean)apiMetadataList.contains((Object)new JcloudsTestComputeApiMetadata()));
        Assert.assertTrue((boolean)apiMetadataList.contains((Object)new JcloudsTestYetAnotherComputeApiMetadata()));
        EasyMock.verify((Object[])new Object[]{bundle});
    }

    private ClassLoader createIsolatedClassLoader() throws MalformedURLException {
        URLClassLoader testClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = testClassLoader.getURLs();
        URLClassLoader loader = new URLClassLoader(urls, null);
        return loader;
    }
}

