/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.jclouds.reflect.Reflection2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class Reflection2Test {
    ImmutableSet<String> setMethods = ImmutableSet.of((Object)"add", (Object)"equals", (Object)"hashCode", (Object)"clear", (Object)"isEmpty", (Object)"contains", (Object[])new String[]{"addAll", "size", "toArray", "iterator", "remove", "removeAll", "containsAll", "retainAll"});
    static final Function<Invokable<?, ?>, String> invokableToName = new Function<Invokable<?, ?>, String>(){

        public String apply(Invokable<?, ?> input) {
            return input.getName();
        }
    };

    public void testTypeTokenForType() {
        TypeLiteral<Set<String>> guice = new TypeLiteral<Set<String>>(){};
        Assert.assertEquals((Object)Reflection2.typeToken((Type)guice.getType()), (Object)new TypeToken<Set<String>>(){
            private static final long serialVersionUID = 1L;
        });
    }

    public void testConstructors() {
        ImmutableSet ctorParams = FluentIterable.from((Iterable)Reflection2.constructors((TypeToken)TypeToken.of(HashSet.class))).transform(new Function<Invokable<?, ?>, Iterable<Parameter>>(){

            public Iterable<Parameter> apply(Invokable<?, ?> input) {
                return input.getParameters();
            }
        }).transform(Functions.toStringFunction()).toSet();
        Assert.assertEquals((Set)ctorParams, (Set)ImmutableSet.of((Object)"[]", (Object)"[java.util.Collection<? extends E> arg0]", (Object)"[int arg0, float arg1]", (Object)"[int arg0]", (Object)"[int arg0, float arg1, boolean arg2]"));
    }

    public void testTypeTokenForClass() {
        Assert.assertEquals((Object)Reflection2.typeToken(String.class), (Object)TypeToken.of(String.class));
    }

    public void testMethodFromJavaMethod() throws SecurityException, NoSuchMethodException {
        Assert.assertEquals((Object)Reflection2.method((TypeToken)Reflection2.typeToken(String.class), (Method)String.class.getMethod("toString", new Class[0])), (Object)TypeToken.of(String.class).method(String.class.getMethod("toString", new Class[0])).returning(String.class));
    }

    public void testMethodFromClassAndNoParams() {
        Invokable methodInSuper = Reflection2.method(Set.class, (String)"iterator", (Class[])new Class[0]);
        Assert.assertEquals((Object)methodInSuper.getOwnerType(), (Object)Reflection2.typeToken(Set.class));
    }

    public void testMethodFromClassAndParams() {
        Invokable methodInSuper = Reflection2.method(Set.class, (String)"equals", (Class[])new Class[]{Object.class});
        Assert.assertEquals((Object)methodInSuper.getOwnerType(), (Object)Reflection2.typeToken(Set.class));
        Assert.assertEquals((Object)((Parameter)methodInSuper.getParameters().get(0)).getType().getRawType(), Object.class);
    }

    public void testMethods() {
        ImmutableSet methodNames = FluentIterable.from((Iterable)Reflection2.methods(Set.class)).transform(invokableToName).transform(Functions.toStringFunction()).toSet();
        Assert.assertEquals((Set)methodNames, this.setMethods);
    }

    public void testMethodsSubClass() {
        ImmutableSet methodNames = FluentIterable.from((Iterable)Reflection2.methods(SortedSet.class)).transform(invokableToName).transform(Functions.toStringFunction()).toSet();
        Assert.assertEquals((Set)methodNames, (Set)ImmutableSet.builder().add(new Object[]{"comparator", "last", "first", "subSet", "headSet", "tailSet"}).addAll(this.setMethods).build());
    }
}

