/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.common.reflect.Invokable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.ContextBuilder;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.filters.StripExpectHeader;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import org.jclouds.http.functions.ReturnInputStream;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.http.options.GetOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.OverrideRequestFilters;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PartParam;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindAsHostPrefix;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.rest.internal.TransformerForRequest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RestAnnotationProcessorTest")
public class RestAnnotationProcessorTest
extends BaseRestApiTest {
    DateService dateService = new SimpleDateFormatDateService();
    RestAnnotationProcessor processor;
    TransformerForRequest transformer;

    public void testAsyncDelegateIsLazyLoadedAndRequestIncludesVersionAndPath() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://localhost:9999/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(AsyncCallee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((AsyncCaller)child.getInstance(AsyncCaller.class)).getCallee().onePath("foo").get();
    }

    public void testDelegateIsLazyLoadedAndRequestIncludesVersionAndPath() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){
            int callCounter = 0;

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                if (this.callCounter == 1) {
                    Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://localhost:1111/client/1/bar/2 HTTP/1.1");
                } else {
                    Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://localhost:1111/client/1/foo HTTP/1.1");
                }
                ++this.callCounter;
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(Callee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((Caller)child.getInstance(Caller.class)).getCallee().onePath("foo");
        ((Caller)child.getInstance(Caller.class)).getCallee2().onePath("bar");
        ((Caller)child.getInstance(Caller.class)).getCallee().onePath("foo");
    }

    public void testAsyncDelegateIsLazyLoadedAndRequestIncludesEndpointVersionAndPath() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://howdyboys/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(AsyncCallee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((AsyncCaller)child.getInstance(AsyncCaller.class)).getCallee(URI.create("http://howdyboys")).onePath("foo").get();
        Assert.assertEquals((Object)((AsyncCaller)child.getInstance(AsyncCaller.class)).getURI(), (Object)URI.create("http://localhost:1111"));
    }

    public void testAsyncDelegateWithPathParamIsLazyLoadedAndRequestIncludesEndpointVersionAndPath() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://howdyboys/testing/testing/thepathparam/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(AsyncCallee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((AsyncCaller)child.getInstance(AsyncCaller.class)).getCalleeWithPath(URI.create("http://howdyboys"), "thepathparam").onePath("foo").get();
        Assert.assertEquals((Object)((AsyncCaller)child.getInstance(AsyncCaller.class)).getURI(), (Object)URI.create("http://localhost:1111"));
    }

    public void testAsyncDelegateIsLazyLoadedAndRequestIncludesEndpointVersionAndPathOptionalPresent() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://howdyboys/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(AsyncCallee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((AsyncCallee)((AsyncCaller)child.getInstance(AsyncCaller.class)).getOptionalCallee(URI.create("http://howdyboys")).get()).onePath("foo").get();
        Assert.assertEquals((Object)((AsyncCaller)child.getInstance(AsyncCaller.class)).getURI(), (Object)URI.create("http://localhost:1111"));
    }

    public void testAsyncDelegateIsLazyLoadedAndRequestIncludesEndpointVersionAndPathCanOverrideOptionalBehaviour() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://howdyboys/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ImplicitOptionalConverter.class).toInstance((Object)new ImplicitOptionalConverter(){

                    public Optional<Object> apply(InvocationSuccess input) {
                        return Optional.absent();
                    }
                });
            }
        }});
        try {
            child.getInstance(AsyncCallee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        assert (!((AsyncCaller)child.getInstance(AsyncCaller.class)).getOptionalCallee(URI.create("http://howdyboys")).isPresent());
        Assert.assertEquals((Object)((AsyncCaller)child.getInstance(AsyncCaller.class)).getURI(), (Object)URI.create("http://localhost:1111"));
    }

    public void testDelegateIsLazyLoadedAndRequestIncludesEndpointVersionAndPath() throws InterruptedException, ExecutionException {
        Injector child = this.injectorForCaller(new HttpCommandExecutorService(){

            public ListenableFuture<HttpResponse> submit(HttpCommand command) {
                return Futures.immediateFuture((Object)this.invoke(command));
            }

            public HttpResponse invoke(HttpCommand command) {
                Assert.assertEquals((String)command.getCurrentRequest().getRequestLine(), (String)"GET http://howdyboys/client/1/foo HTTP/1.1");
                return HttpResponse.builder().build();
            }
        }, new Module[0]);
        try {
            child.getInstance(Callee.class);
            Assert.fail((String)"Callee shouldn't be bound yet");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Caller)child.getInstance(Caller.class)).getURI(), (Object)URI.create("http://localhost:1111"));
    }

    private Injector injectorForCaller(HttpCommandExecutorService service, Module ... modules) {
        return ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(Caller.class, AsyncCaller.class, (String)"http://localhost:9999")).modules((Iterable)ImmutableSet.builder().add((Object)new BaseRestApiTest.MockModule(service)).add((Object)new NullLoggingModule()).add((Object)new CallerModule()).addAll((Iterable)ImmutableSet.copyOf((Object[])modules)).build()).buildInjector();
    }

    public void testQuery() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"foo", (Class[])new Class[0])));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&x-ms-rubbish=bin");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQuery2() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"foo2", (Class[])new Class[0])));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=bar&fooble=baz");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQuery3() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"foo3", (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)"wonder")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=bar&fooble=baz&robbie=wonder");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="param\\{robbie\\} for invocation TestQuery.foo3")
    public void testNiceNPEQueryParam() throws SecurityException, NoSuchMethodException, IOException {
        this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"foo3", (Class[])new Class[]{String.class}), (List)Lists.newArrayList((Object[])new Object[]{null})));
    }

    public void testNoNPEOnQueryParamWithNullable() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"foo3Nullable", (Class[])new Class[]{String.class}), (List)Lists.newArrayList((Object[])new Object[]{null})));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=bar&fooble=baz");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQueryParamIterableOneString() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)Reflection2.method(TestQuery.class, (String)"queryParamIterable", (Class[])new Class[]{Iterable.class}), (List)ImmutableList.of((Object)ImmutableSet.of((Object)"1"))));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=1");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQueryParamIterableString() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQuery.class, (String)"queryParamIterable", (Class[])new Class[]{Iterable.class});
        ImmutableSortedSet bars = ImmutableSortedSet.of((Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"));
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)bars)));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=1&foo=2&foo=3");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQueryParamIterableInteger() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQuery.class, (String)"queryParamIterable", (Class[])new Class[]{Iterable.class});
        ImmutableSortedSet bars = ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3));
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)bars)));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17&foo=1&foo=2&foo=3");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQueryParamIterableEmpty() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQuery.class, (String)"queryParamIterable", (Class[])new Class[]{Iterable.class});
        Set bars = Collections.emptySet();
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of(bars)));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testQueryParamIterableNull() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQuery.class, (String)"queryParamIterable", (Class[])new Class[]{Iterable.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"x-ms-version=2009-07-17");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testHttpRequestOptionsNoPayloadParam() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"post", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "", "application/octet-stream", false);
    }

    public void testHttpRequestOptionsPayloadParam() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"post", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)Payloads.newStringPayload((String)"foo"))));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "foo", "application/octet-stream", false);
    }

    public void testHttpRequestWithOnlyContentType() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"post", (Class[])new Class[]{HttpRequestOptions.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)((Object)new TestHttpRequestOptions().payload("fooya")))));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "fooya", "application/unknown", false);
    }

    public void testHeaderAndQueryVarargs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"varargs", (Class[])new Class[]{HttpRequestOptions[].class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)((Object)new TestHttpRequestOptions().payload("fooya")), (Object)((Object)new TestHttpRequestOptions().headerParams((Multimap<String, String>)ImmutableMultimap.of((Object)"X-header-1", (Object)"fooya"))), (Object)((Object)new TestHttpRequestOptions().queryParams((Multimap<String, String>)ImmutableMultimap.of((Object)"key", (Object)"value"))))));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999?key=value HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "X-header-1: fooya\n");
        this.assertPayloadEquals((HttpRequest)request, "fooya", "application/unknown", false);
    }

    public void testHeaderAndQueryVarargsPlusReq() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"varargsWithReq", (Class[])new Class[]{String.class, HttpRequestOptions[].class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"required param", (Object)((Object)new TestHttpRequestOptions().payload("fooya")), (Object)((Object)new TestHttpRequestOptions().headerParams((Multimap<String, String>)ImmutableMultimap.of((Object)"X-header-1", (Object)"fooya"))), (Object)((Object)new TestHttpRequestOptions().queryParams((Multimap<String, String>)ImmutableMultimap.of((Object)"key", (Object)"value"))))));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999?key=value HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "X-header-1: fooya\n");
        this.assertPayloadEquals((HttpRequest)request, "fooya", "application/unknown", false);
    }

    public void testDuplicateHeaderAndQueryVarargs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayloadParamVarargs.class, (String)"varargs", (Class[])new Class[]{HttpRequestOptions[].class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)((Object)new TestHttpRequestOptions().queryParams((Multimap<String, String>)ImmutableMultimap.of((Object)"key", (Object)"value"))), (Object)((Object)new TestHttpRequestOptions().payload("fooya")), (Object)((Object)new TestHttpRequestOptions().headerParams((Multimap<String, String>)ImmutableMultimap.of((Object)"X-header-1", (Object)"fooya"))), (Object)((Object)new TestHttpRequestOptions().queryParams((Multimap<String, String>)ImmutableMultimap.of((Object)"key", (Object)"anothervalue"))), (Object)((Object)new TestHttpRequestOptions().headerParams((Multimap<String, String>)ImmutableMultimap.of((Object)"X-header-1", (Object)"fooya again!"))), (Object)((Object)new TestHttpRequestOptions().payload("last_payload_wins!")))));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999?key=value&key=anothervalue HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "X-header-1: fooya\nX-header-1: fooya again!\n");
        this.assertPayloadEquals((HttpRequest)request, "last_payload_wins!", "application/unknown", false);
    }

    public void testCustomMethod() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestCustomMethod.class, (String)"foo", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"");
        Assert.assertEquals((String)request.getMethod(), (String)"FOO");
    }

    public void testOverriddenMethod() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestOverridden.class, (String)"foo", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"");
        Assert.assertEquals((String)request.getMethod(), (String)"POST");
    }

    public void testOverriddenEndpointMethod() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestOverriddenEndpoint.class, (String)"foo", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((int)request.getEndpoint().getPort(), (int)1111);
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"");
        Assert.assertEquals((String)request.getMethod(), (String)"POST");
    }

    public void testOverriddenEndpointParameter() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestOverriddenEndpoint.class, (String)"foo", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)URI.create("http://wowsa:8001"))));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"wowsa");
        Assert.assertEquals((int)request.getEndpoint().getPort(), (int)8001);
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"");
        Assert.assertEquals((String)request.getMethod(), (String)"POST");
    }

    public void testCreatePostRequest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"post", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "data", "application/unknown", false);
    }

    public void testCreatePostRequestNullOk1() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"post", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, "application/unknown", false);
    }

    public void testCreatePostRequestNullOk2() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"post", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, "application/unknown", false);
    }

    public void testCreatePostRequestNullNotOk1() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postNonnull", (Class[])new Class[]{String.class});
        try {
            GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
            Assert.fail((String)("call should have failed with illegal null parameter, not permitted " + request + " to be created"));
        }
        catch (NullPointerException e) {
            Assert.assertTrue((e.toString().indexOf("postNonnull parameter 1") >= 0 ? 1 : 0) != 0, (String)("Error message should have referred to 'parameter 1': " + e));
        }
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="postNonnull parameter 1")
    public void testCreatePostRequestNullNotOk2() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postNonnull", (Class[])new Class[]{String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
    }

    public void testCreatePostJsonRequest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postAsJson", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "\"data\"", "application/json", false);
    }

    public void testCreatePostWithPathRequest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postWithPath", (Class[])new Class[]{String.class, org.jclouds.rest.annotations.MapBinder.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data", (Object)new MapBinder(){

            public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
                request.setPayload((String)postParams.get("fooble"));
                return request;
            }

            public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
                throw new RuntimeException("this shouldn't be used in POST");
            }
        })));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999/data HTTP/1.1");
        this.assertPayloadEquals((HttpRequest)request, "data", "application/unknown", false);
    }

    public void testCreatePostWithMethodBinder() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postWithMethodBinder", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"fooble\":\"data\"}", "application/json", false);
    }

    public void testCreatePostWithMethodBinderAndDefaults() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"postWithMethodBinderAndDefaults", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"fooble\":\"data\",\"rat\":\"atat\"}", "application/json", false);
    }

    public void testCreatePostWithPayload() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPost.class, (String)"testPayload", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "name data", "text/plain", false);
    }

    public void testMultipartWithStringPart() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withStringPart", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"foobledata")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, "----JCLOUDS--\r\nContent-Disposition: form-data; name=\"fooble\"\r\n\r\nfoobledata\r\n----JCLOUDS----\r\n", "multipart/form-data; boundary=--JCLOUDS--", false);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="fooble")
    public void testMultipartWithStringPartNullNotOkay() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withStringPart", (Class[])new Class[]{String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
    }

    public void testMultipartWithParamStringPart() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withParamStringPart", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"name", (Object)"foobledata")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, "----JCLOUDS--\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nname\r\n----JCLOUDS--\r\nContent-Disposition: form-data; name=\"file\"\r\n\r\nfoobledata\r\n----JCLOUDS----\r\n", "multipart/form-data; boundary=--JCLOUDS--", false);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="param\\{name\\} for invocation TestMultipartForm.withParamStringPart")
    public void testMultipartWithParamStringPartNullNotOk() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withParamStringPart", (Class[])new Class[]{String.class, String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null, "foobledata"})));
    }

    public void testMultipartWithParamFilePart() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withParamFilePart", (Class[])new Class[]{String.class, File.class});
        File file = File.createTempFile("foo", "bar");
        Files.append((CharSequence)"foobledata", (File)file, (Charset)Charsets.UTF_8);
        file.deleteOnExit();
        GeneratedHttpRequest httpRequest = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"name", (Object)file)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, "----JCLOUDS--\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nname\r\n----JCLOUDS--\r\nContent-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n" + "\r\n" + "foobledata\r\n" + "----JCLOUDS----\r\n", "multipart/form-data; boundary=--JCLOUDS--", false);
    }

    public void testMultipartWithParamByteArrayPart() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withParamByteArrayBinaryPart", (Class[])new Class[]{String.class, byte[].class});
        GeneratedHttpRequest httpRequest = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"name", (Object)"goo".getBytes())));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, "----JCLOUDS--\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nname\r\n----JCLOUDS--\r\nContent-Disposition: form-data; name=\"file\"; filename=\"name.tar.gz\"\r\nContent-Type: application/octet-stream\r\n\r\ngoo\r\n----JCLOUDS----\r\n", "multipart/form-data; boundary=--JCLOUDS--", false);
    }

    public void testMultipartWithParamFileBinaryPart() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestMultipartForm.class, (String)"withParamFileBinaryPart", (Class[])new Class[]{String.class, File.class});
        File file = File.createTempFile("foo", "bar");
        Files.write((byte[])new byte[]{17, 26, 39, 40, 50}, (File)file);
        file.deleteOnExit();
        GeneratedHttpRequest httpRequest = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"name", (Object)file)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, "----JCLOUDS--\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nname\r\n----JCLOUDS--\r\nContent-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n" + "Content-Type: application/octet-stream\r\n" + "\r\n" + "\u0011\u001a'(2\r\n" + "----JCLOUDS----\r\n", "multipart/form-data; boundary=--JCLOUDS--", false);
    }

    public void testAlternateHttpMethod() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"rowdy", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "ROWDY http://localhost:9999/strings/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testAlternateHttpMethodSameArity() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"rowdy", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "ROWDY http://localhost:9999/ints/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCreatePutWithMethodBinder() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"putWithMethodBinder", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"fooble\":\"data\"}", "application/json", false);
    }

    public void testCreatePutWithMethodProduces() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"putWithMethodBinderProduces", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "data", "text/plain", false);
    }

    public void testCreatePutWithMethodConsumes() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"putWithMethodBinderConsumes", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/data HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"fooble\":\"data\"}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ParseJson.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((String)((View)View.class.cast((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode((int)200).message((String)"ok").payload((String)"{ foo:\"bar\"}")).build()))).foo, (String)"bar");
    }

    public void testGeneric1() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testGeneric", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, ParseJson.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    public void testGeneric2() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testGeneric2", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, ParseJson.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    public void testGeneric3() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testGeneric3", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, ParseJson.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    public void testUnwrap1() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testUnwrap", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)"bar");
    }

    public void testUnwrapValueNamed() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testUnwrapValueNamed", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, ParseFirstJsonValueNamed.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)"bar");
    }

    public void testWrapWith() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testWrapWith", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"bar")));
        this.assertPayloadEquals((HttpRequest)request, "{\"foo\":\"bar\"}", "application/json", false);
    }

    public void testUnwrap2() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testUnwrap2", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ foo:\"bar\"}")).build()), (Object)"bar");
    }

    public void testUnwrap3() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testUnwrap3", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{\"runit\":[\"0.7.0\",\"0.7.1\"]}")).build()), (Object)ImmutableSet.of((Object)"0.7.0", (Object)"0.7.1"));
    }

    public void testUnwrap4() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"testUnwrap4", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{\"runit\":[\"0.7.0\",\"0.7.1\"]}")).build()), (Object)ImmutableSet.of((Object)"0.7.0", (Object)"0.7.1"));
    }

    public void selectLong() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"selectLong", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        this.assertResponseParserClassEquals(method, request, ParseFirstJsonValueNamed.class);
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ \"destroyvirtualmachineresponse\" : {\"jobid\":4} }")).build()), (Object)4L);
    }

    public void selectLongAddOne() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPut.class, (String)"selectLongAddOne", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Function parser = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals((Object)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("{ \"destroyvirtualmachineresponse\" : {\"jobid\":4} }")).build()), (Object)5L);
    }

    @Test
    public void testRequestFilter() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequestFilter.class, (String)"get", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Assert.assertEquals((int)request.getFilters().size(), (int)2);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), TestRequestFilter1.class);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(1)).getClass(), TestRequestFilter2.class);
    }

    public void testRequestFilterOverride() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequestFilter.class, (String)"getOverride", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method));
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), TestRequestFilter2.class);
    }

    public void testRequestFilterOverrideOnRequest() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequestFilter.class, (String)"getOverride", (Class[])new Class[]{HttpRequest.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost").addHeader("foo", new String[]{"bar"})).build())));
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals((int)request.getHeaders().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), TestRequestFilter2.class);
    }

    @Test
    public void testRequestFilterStripExpect() {
        Invokable method = Reflection2.method(TestRequestFilter.class, (String)"post", (Class[])new Class[0]);
        Invocation invocation = Invocation.create((Invokable)method, (List)ImmutableList.of((Object)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost").addHeader("Expect", new String[]{"100-Continue"})).build()));
        GeneratedHttpRequest request = this.processor.apply(invocation);
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), TestRequestFilter1.class);
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.strip-expect-header", "true");
        Injector injector = ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(Callee.class, AsyncCallee.class, (String)"http://localhost:9999")).modules((Iterable)ImmutableSet.of((Object)((Object)new BaseRestApiTest.MockModule()), (Object)new NullLoggingModule(), (Object)new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Localhost2.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("http://localhost:1111")));
            }
        })).overrides(overrides).buildInjector();
        RestAnnotationProcessor newProcessor = (RestAnnotationProcessor)injector.getInstance(RestAnnotationProcessor.class);
        request = newProcessor.apply(invocation);
        Assert.assertEquals((int)request.getFilters().size(), (int)2);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(1)).getClass(), StripExpectHeader.class);
    }

    @Test
    public void testSkipEncoding() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestEncoding.class, (String)"twoPaths", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"localhost")));
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1/localhost");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    @Test
    public void testEncodingPath() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestEncoding.class, (String)"twoPaths", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"/", (Object)"localhost")));
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"///localhost");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    @Test(enabled=false)
    public void testConstantPathParam() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestConstantPathParam.class, (String)"twoPaths", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"localhost")));
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:9999/v1/ralphie/1/localhost HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="param\\{path\\} for invocation TestPath.onePath")
    public void testNiceNPEPathParam() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPath.class, (String)"onePath", (Class[])new Class[]{String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
    }

    @Test
    public void testPathParamExtractor() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPath.class, (String)"onePathParamExtractor", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"localhost")));
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:9999/l HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    @Test
    public void testQueryParamExtractor() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPath.class, (String)"oneQueryParamExtractor", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"localhost")));
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:9999/?one=l HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    @Test
    public void testFormParamExtractor() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPath.class, (String)"oneFormParamExtractor", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"localhost")));
        this.assertRequestLineEquals((HttpRequest)request, "POST http://localhost:9999/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "one=l", "application/x-www-form-urlencoded", false);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="param\\{one\\} for invocation TestPath.oneFormParamExtractor")
    public void testNiceNPEFormParam() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPath.class, (String)"oneFormParamExtractor", (Class[])new Class[]{String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)Lists.newArrayList((Object[])new Object[]{null})));
    }

    @Test
    public void testBuildTwoHeader() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestHeader.class, (String)"twoHeader", (Class[])new Class[]{String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)2);
        Assert.assertEquals((Collection)headers.get((Object)"slash"), (Collection)ImmutableList.of((Object)"/robot"));
        Assert.assertEquals((Collection)headers.get((Object)"hyphen"), (Collection)ImmutableList.of((Object)"-robot"));
    }

    @Test
    public void testBuildOneClassHeader() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestClassHeader.class, (String)"oneHeader", (Class[])new Class[]{String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"x-amz-copy-source"), (Collection)ImmutableList.of((Object)"/robot"));
    }

    @Test
    public void testBuildOneHeader() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestHeader.class, (String)"oneHeader", (Class[])new Class[]{String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"x-amz-copy-source"), (Collection)ImmutableList.of((Object)"/robot"));
    }

    @Test
    public void testBuildTwoHeaders() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestHeader.class, (String)"twoHeaders", (Class[])new Class[]{String.class, String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"x-amz-copy-source"), (Collection)ImmutableList.of((Object)"/robot/eggs"));
    }

    @Test
    public void testBuildTwoHeadersOutOfOrder() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestHeader.class, (String)"twoHeadersOutOfOrder", (Class[])new Class[]{String.class, String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"x-amz-copy-source"), (Collection)ImmutableList.of((Object)"/eggs/robot"));
    }

    @Test
    public void testQueryInOptions() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQueryReplace.class, (String)"queryInOptions", (Class[])new Class[]{String.class, TestReplaceQueryOptions.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)((Object)new TestReplaceQueryOptions())))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"x-amz-copy-source=/robot");
    }

    @Test
    public void testBuildTwoQuery() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQueryReplace.class, (String)"twoQuery", (Class[])new Class[]{String.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"slash=/robot&hyphen=-robot");
    }

    @Test
    public void testBuildOneClassQuery() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestClassQuery.class, (String)"oneQuery", (Class[])new Class[]{String.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"x-amz-copy-source=/robot");
    }

    @Test
    public void testBuildOneQuery() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQueryReplace.class, (String)"oneQuery", (Class[])new Class[]{String.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"x-amz-copy-source=/robot");
    }

    @Test
    public void testBuildTwoQuerys() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQueryReplace.class, (String)"twoQuerys", (Class[])new Class[]{String.class, String.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"x-amz-copy-source=/robot/eggs");
    }

    @Test
    public void testBuildTwoQuerysOutOfOrder() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestQueryReplace.class, (String)"twoQuerysOutOfOrder", (Class[])new Class[]{String.class, String.class});
        String query = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getEndpoint().getQuery();
        Assert.assertEquals((String)query, (String)"x-amz-copy-source=/eggs/robot");
    }

    public void testPutPayloadEnclosing() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{PayloadEnclosing.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)new PayloadEnclosingImpl((org.jclouds.io.Payload)Payloads.newStringPayload((String)"whoops")))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", false);
    }

    public void testPutPayloadEnclosingGenerateMD5() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{PayloadEnclosing.class});
        PayloadEnclosingImpl payloadEnclosing = new PayloadEnclosingImpl((org.jclouds.io.Payload)Payloads.newStringPayload((String)"whoops"));
        Payloads.calculateMD5((PayloadEnclosing)payloadEnclosing);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payloadEnclosing)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", true);
    }

    public void testPutInputStreamPayloadEnclosingGenerateMD5() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{PayloadEnclosing.class});
        PayloadEnclosingImpl payloadEnclosing = new PayloadEnclosingImpl((org.jclouds.io.Payload)Payloads.newInputStreamPayload((InputStream)Strings2.toInputStream((String)"whoops")));
        Payloads.calculateMD5((PayloadEnclosing)payloadEnclosing);
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payloadEnclosing)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", true);
    }

    public void testPutPayloadChunkedNoContentLength() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"putXfer", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)Payloads.newStringPayload((String)"whoops"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Transfer-Encoding: chunked\n");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", false);
    }

    public void testPutPayload() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)Payloads.newStringPayload((String)"whoops"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", false);
    }

    public void testPutPayloadContentDisposition() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        StringPayload payload = Payloads.newStringPayload((String)"whoops");
        payload.getContentMetadata().setContentDisposition("attachment; filename=photo.jpg");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", "attachment; filename=photo.jpg", null, null, false);
    }

    public void testPutPayloadContentEncoding() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        StringPayload payload = Payloads.newStringPayload((String)"whoops");
        payload.getContentMetadata().setContentEncoding("gzip");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", null, "gzip", null, false);
    }

    public void testPutPayloadContentLanguage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        StringPayload payload = Payloads.newStringPayload((String)"whoops");
        payload.getContentMetadata().setContentLanguage("en");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", null, null, "en", false);
    }

    public void testPutPayloadWithGeneratedMD5AndNoContentType() throws SecurityException, NoSuchMethodException, IOException {
        StringPayload payload = Payloads.newStringPayload((String)"whoops");
        Payloads.calculateMD5((org.jclouds.io.Payload)payload);
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", true);
    }

    public void testPutInputStreamPayload() throws SecurityException, NoSuchMethodException, IOException {
        InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)Strings2.toInputStream((String)"whoops"));
        payload.getContentMetadata().setContentLength(Long.valueOf("whoops".length()));
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", false);
    }

    public void testPutInputStreamPayloadWithMD5() throws NoSuchAlgorithmException, IOException, SecurityException, NoSuchMethodException {
        StringPayload payload = Payloads.newStringPayload((String)"whoops");
        Payloads.calculateMD5((org.jclouds.io.Payload)payload);
        Invokable method = Reflection2.method(TestTransformers.class, (String)"put", (Class[])new Class[]{org.jclouds.io.Payload.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)payload)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "whoops", "application/unknown", true);
    }

    public void testInputStreamListenableFuture() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"futureInputStream", (Class[])new Class[0]);
        Class<Function<HttpResponse, ?>> transformer = this.unwrap(TestTransformers.class, method);
        Assert.assertEquals(transformer, ReturnInputStream.class);
    }

    public <T> Class<? extends Function<HttpResponse, ?>> unwrap(Class<T> type, Invokable<?, ?> method) {
        return this.transformer.getParserOrThrowException(Invocation.create(method, (List)ImmutableList.of())).getTypeLiteral().getRawType();
    }

    public void testURIListenableFuture() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"futureUri", (Class[])new Class[0]);
        Class<Function<HttpResponse, ?>> transformer = this.unwrap(TestTransformers.class, method);
        Assert.assertEquals(transformer, ParseURIFromListOrLocationHeaderIf20x.class);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testNoTransformer() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"noTransformer", (Class[])new Class[0]);
        this.unwrap(TestTransformers.class, method);
    }

    public void oneTransformerWithContext() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).endpoint("http://localhost")).invocation(Invocation.create((Invokable)Reflection2.method(TestTransformers.class, (String)"oneTransformerWithContext", (Class[])new Class[0]), (List)ImmutableList.of())).build();
        Function transformer = this.transformer.apply((HttpRequest)request);
        Assert.assertEquals(transformer.getClass(), ReturnStringIf200Context.class);
        Assert.assertEquals((Object)((ReturnStringIf200Context)transformer).request, (Object)request);
    }

    public void testOneTransformer() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestTransformers.class, (String)"oneTransformer", (Class[])new Class[0]);
        Class<Function<HttpResponse, ?>> transformer = this.unwrap(TestTransformers.class, method);
        Assert.assertEquals(transformer, ReturnStringIf2xx.class);
    }

    public void testCreateGetVarArgOptionsThatProducesHeaders() throws SecurityException, NoSuchMethodException {
        Date date = new Date();
        GetOptions options = GetOptions.Builder.ifModifiedSince((Date)date);
        Invokable method = Reflection2.method(TestRequest.class, (String)"get", (Class[])new Class[]{String.class, HttpRequestOptions[].class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)options)));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)2);
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"Host"), (Collection)ImmutableList.of((Object)"localhost:9999"));
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"If-Modified-Since"), (Collection)ImmutableList.of((Object)this.dateService.rfc822DateFormat(date)));
    }

    public void testCreateGetOptionsThatProducesHeaders() throws SecurityException, NoSuchMethodException {
        Date date = new Date();
        GetOptions options = GetOptions.Builder.ifModifiedSince((Date)date);
        Invokable method = Reflection2.method(TestRequest.class, (String)"get", (Class[])new Class[]{String.class, HttpRequestOptions.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)options)));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)2);
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"Host"), (Collection)ImmutableList.of((Object)"localhost:9999"));
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"If-Modified-Since"), (Collection)ImmutableList.of((Object)this.dateService.rfc822DateFormat(date)));
    }

    public void testCreateGetOptionsThatProducesQuery() throws SecurityException, NoSuchMethodException, IOException {
        PrefixOptions options = new PrefixOptions().withPrefix("1");
        Invokable method = Reflection2.method(TestRequest.class, (String)"get", (Class[])new Class[]{String.class, HttpRequestOptions.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)((Object)options))));
        this.assertRequestLineEquals((HttpRequest)request, "GET http://localhost:9999/1?prefix=1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: localhost:9999\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCreateGetQuery() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"getQuery", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"max-keys=0");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    public void testCreateGetQueryNull() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"getQueryNull", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"acl");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    public void testCreateGetQueryEmpty() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"getQueryEmpty", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getEndpoint().getQuery(), (String)"acl=");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    public void testCreateGetOptionsThatProducesPayload() throws SecurityException, NoSuchMethodException, IOException {
        PayloadOptions options = new PayloadOptions();
        Invokable method = Reflection2.method(TestRequest.class, (String)"putOptions", (Class[])new Class[]{String.class, HttpRequestOptions.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)((Object)options))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: localhost:9999\n");
        this.assertPayloadEquals((HttpRequest)request, "foo", "application/unknown", false);
    }

    @DataProvider(name="strings")
    public Object[][] createData() {
        return new Object[][]{{"apples"}, {"sp ace"}, {"unic\u20aade"}, {"qu?stion"}};
    }

    @Test(dataProvider="strings")
    public void testCreateGetRequest(String key) throws SecurityException, NoSuchMethodException, UnsupportedEncodingException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"get", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)key, (Object)"localhost")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        String expectedPath = "/" + URLEncoder.encode(key, "UTF-8").replaceAll("\\+", "%20");
        Assert.assertEquals((String)request.getEndpoint().getRawPath(), (String)expectedPath);
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)("/" + key));
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)1);
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"Host"), (Collection)ImmutableList.of((Object)"localhost"));
    }

    public void testCreatePutRequest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"put", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"111", (Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "data", "application/unknown", false);
    }

    public void testCreatePutHeader() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestRequest.class, (String)"putHeader", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"data")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "foo: --1--\n");
        this.assertPayloadEquals((HttpRequest)request, "data", "application/unknown", false);
    }

    @Test
    public void testVirtualHostMethod() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestVirtualHostMethod.class, (String)"get", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"localhost")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)1);
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"Host"), (Collection)ImmutableList.of((Object)"localhost:9999"));
    }

    @Test
    public void testVirtualHost() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestVirtualHost.class, (String)"get", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"localhost")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)1);
        Assert.assertEquals((Collection)request.getHeaders().get((Object)"Host"), (Collection)ImmutableList.of((Object)"localhost:9999"));
    }

    @Test
    public void testHostPrefix() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestVirtualHost.class, (String)"getPrefix", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"holy")));
        Assert.assertEquals((String)request.getEndpoint().getHost(), (String)"holy.localhost");
        Assert.assertEquals((String)request.getEndpoint().getPath(), (String)"/1");
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((int)request.getHeaders().size(), (int)0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testHostPrefixEmpty() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestVirtualHost.class, (String)"getPrefix", (Class[])new Class[]{String.class, String.class});
        this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"1", (Object)"")));
    }

    @Test
    public void testOneHeader() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestHeaders.class, (String)"oneHeader", (Class[])new Class[]{String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"header"), (Collection)ImmutableList.of((Object)"robot"));
    }

    @Test
    public void testOneIntHeader() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestHeaders.class, (String)"oneIntHeader", (Class[])new Class[]{Integer.TYPE});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)1))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((Collection)headers.get((Object)"header"), (Collection)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testTwoDifferentHeaders() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestHeaders.class, (String)"twoDifferentHeaders", (Class[])new Class[]{String.class, String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"egg"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)2);
        Assert.assertEquals((Collection)headers.get((Object)"header1"), (Collection)ImmutableList.of((Object)"robot"));
        Assert.assertEquals((Collection)headers.get((Object)"header2"), (Collection)ImmutableList.of((Object)"egg"));
    }

    @Test
    public void testTwoSameHeaders() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestHeaders.class, (String)"twoSameHeaders", (Class[])new Class[]{String.class, String.class});
        Multimap headers = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"egg"))).getHeaders();
        Assert.assertEquals((int)headers.size(), (int)2);
        Collection values = headers.get((Object)"header");
        assert (values.contains("robot"));
        assert (values.contains("egg"));
    }

    @Test
    public void testOneEndpointParam() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestEndpointParams.class, (String)"oneEndpointParam", (Class[])new Class[]{String.class});
        URI uri = RestAnnotationProcessor.getEndpointInParametersOrNull((Invocation)Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot")), (Injector)this.injector);
        Assert.assertEquals((Object)uri, (Object)URI.create("robot"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testTwoDifferentEndpointParams() throws SecurityException, NoSuchMethodException, ExecutionException {
        Invokable method = Reflection2.method(TestEndpointParams.class, (String)"twoEndpointParams", (Class[])new Class[]{String.class, String.class});
        RestAnnotationProcessor.getEndpointInParametersOrNull((Invocation)Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"egg")), (Injector)this.injector);
    }

    @Test
    public void testPut() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayload.class, (String)"put", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"test")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "test", "application/unknown", false);
    }

    @Test
    public void putWithPath() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TestPayload.class, (String)"putWithPath", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"rabble", (Object)"test")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://localhost:9999/rabble HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "test", "application/unknown", false);
    }

    @Test
    public void testBuildTwoForm() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestFormReplace.class, (String)"twoForm", (Class[])new Class[]{String.class});
        Object form = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getPayload().getRawContent();
        Assert.assertEquals((Object)form, (Object)"slash=/robot&hyphen=-robot");
    }

    @Test
    public void testBuildOneClassForm() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestClassForm.class, (String)"oneForm", (Class[])new Class[]{String.class});
        Object form = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getPayload().getRawContent();
        Assert.assertEquals((Object)form, (Object)"x-amz-copy-source=/robot");
    }

    @Test
    public void testBuildOneForm() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestFormReplace.class, (String)"oneForm", (Class[])new Class[]{String.class});
        Object form = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot"))).getPayload().getRawContent();
        Assert.assertEquals((Object)form, (Object)"x-amz-copy-source=/robot");
    }

    @Test
    public void testBuildTwoForms() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestFormReplace.class, (String)"twoForms", (Class[])new Class[]{String.class, String.class});
        Object form = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getPayload().getRawContent();
        Assert.assertEquals((Object)form, (Object)"x-amz-copy-source=/robot/eggs");
    }

    @Test
    public void testBuildTwoFormsOutOfOrder() throws SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(TestFormReplace.class, (String)"twoFormsOutOfOrder", (Class[])new Class[]{String.class, String.class});
        Object form = this.processor.apply(Invocation.create((Invokable)method, (List)ImmutableList.of((Object)"robot", (Object)"eggs"))).getPayload().getRawContent();
        Assert.assertEquals((Object)form, (Object)"x-amz-copy-source=/eggs/robot");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddHostNullWithHost() throws Exception {
        Assert.assertNull((Object)RestAnnotationProcessor.addHostIfMissing(null, null));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddHostWithHostHasNoHost() throws Exception {
        Assert.assertNull((Object)RestAnnotationProcessor.addHostIfMissing(null, (URI)new URI("/no/host")));
    }

    @Test
    public void testAddHostNullOriginal() throws Exception {
        Assert.assertNull((Object)RestAnnotationProcessor.addHostIfMissing(null, (URI)new URI("http://foo")));
    }

    @Test
    public void testAddHostOriginalHasHost() throws Exception {
        URI original = new URI("http://hashost/foo");
        URI result = RestAnnotationProcessor.addHostIfMissing((URI)original, (URI)new URI("http://foo"));
        Assert.assertEquals((Object)original, (Object)result);
    }

    @Test
    public void testAddHostIfMissing() throws Exception {
        URI result = RestAnnotationProcessor.addHostIfMissing((URI)new URI("/bar"), (URI)new URI("http://foo"));
        Assert.assertEquals((Object)new URI("http://foo/bar"), (Object)result);
    }

    @BeforeClass
    void setupFactory() {
        this.injector = ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(Callee.class, AsyncCallee.class, (String)"http://localhost:9999")).modules((Iterable)ImmutableSet.of((Object)((Object)new BaseRestApiTest.MockModule()), (Object)new NullLoggingModule(), (Object)new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Localhost2.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("http://localhost:1111")));
            }
        })).buildInjector();
        this.parserFactory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        this.processor = (RestAnnotationProcessor)this.injector.getInstance(RestAnnotationProcessor.class);
        this.transformer = (TransformerForRequest)this.injector.getInstance(TransformerForRequest.class);
    }

    @FormParams(keys={"x-amz-copy-source"}, values={"/{bucket}"})
    public static interface TestClassForm {
        @POST
        @Path(value="/")
        public void oneForm(@PathParam(value="bucket") String var1);
    }

    public class TestFormReplace {
        @POST
        @Path(value="/")
        public void formInOptions(@PathParam(value="bucket") String path, TestReplaceFormOptions options) {
        }

        @POST
        @Path(value="/")
        @FormParams(keys={"x-amz-copy-source"}, values={"/{bucket}"})
        public void oneForm(@PathParam(value="bucket") String path) {
        }

        @POST
        @Path(value="/")
        @FormParams(keys={"slash", "hyphen"}, values={"/{bucket}", "-{bucket}"})
        public void twoForm(@PathParam(value="bucket") String path) {
        }

        @POST
        @Path(value="/")
        @FormParams(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoForms(@PathParam(value="bucket") String path, @PathParam(value="key") String path2) {
        }

        @POST
        @Path(value="/")
        @FormParams(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoFormsOutOfOrder(@PathParam(value="key") String path, @PathParam(value="bucket") String path2) {
        }
    }

    public class TestReplaceFormOptions
    extends BaseHttpRequestOptions {
        public TestReplaceFormOptions() {
            this.formParameters.put((Object)"x-amz-copy-source", (Object)"/{bucket}");
        }
    }

    public static interface TestPayload {
        @PUT
        public void put(@BinderParam(value=BindToStringPayload.class) String var1);

        @PUT
        @Path(value="/{foo}")
        public ListenableFuture<Void> putWithPath(@PathParam(value="foo") String var1, @BinderParam(value=BindToStringPayload.class) String var2);

        @PUT
        public void twoEntities(@BinderParam(value=BindToStringPayload.class) String var1, @BinderParam(value=BindToStringPayload.class) String var2);
    }

    public static interface TestEndpointParams {
        @GET
        public void oneEndpointParam(@EndpointParam(parser=ConvertToURI.class) String var1);

        @GET
        public void twoEndpointParams(@EndpointParam(parser=ConvertTwoToURI.class) String var1, @EndpointParam(parser=ConvertTwoToURI.class) String var2);

        @Singleton
        public static class ConvertTwoToURI
        implements Function<Object, URI> {
            public URI apply(Object from) {
                return URI.create(Joiner.on((char)'/').join((Iterable)from));
            }
        }

        @Singleton
        public static class ConvertToURI
        implements Function<Object, URI> {
            public URI apply(Object from) {
                return URI.create(from.toString());
            }
        }
    }

    public static interface TestHeaders {
        @GET
        public void oneHeader(@HeaderParam(value="header") String var1);

        @GET
        public void oneIntHeader(@HeaderParam(value="header") int var1);

        @GET
        public void twoDifferentHeaders(@HeaderParam(value="header1") String var1, @HeaderParam(value="header2") String var2);

        @GET
        public void twoSameHeaders(@HeaderParam(value="header") String var1, @HeaderParam(value="header") String var2);
    }

    public static interface TestVirtualHost {
        @GET
        @Path(value="/{id}")
        @VirtualHost
        public ListenableFuture<String> get(@PathParam(value="id") String var1, String var2);

        @GET
        @Path(value="/{id}")
        public ListenableFuture<String> getPrefix(@PathParam(value="id") String var1, @BinderParam(value=BindAsHostPrefix.class) String var2);
    }

    public class TestVirtualHostMethod {
        @GET
        @Path(value="/{id}")
        @VirtualHost
        public ListenableFuture<String> get(@PathParam(value="id") String id, String foo) {
            return null;
        }
    }

    public class PayloadOptions
    extends BaseHttpRequestOptions {
        public String buildStringPayload() {
            return "foo";
        }
    }

    public class PrefixOptions
    extends BaseHttpRequestOptions {
        public PrefixOptions withPrefix(String prefix) {
            this.queryParameters.put((Object)"prefix", Preconditions.checkNotNull((Object)prefix, (Object)"prefix"));
            return this;
        }
    }

    public static interface TestRequest {
        @GET
        @VirtualHost
        @Path(value="/{id}")
        public ListenableFuture<String> get(@PathParam(value="id") String var1, HttpRequestOptions var2);

        @GET
        @VirtualHost
        @Path(value="/{id}")
        public ListenableFuture<String> get(@PathParam(value="id") String var1, HttpRequestOptions ... var2);

        @GET
        @Path(value="/{id}")
        @ResponseParser(value=ReturnStringIf2xx.class)
        public ListenableFuture<String> get(@PathParam(value="id") String var1, @HeaderParam(value="Host") String var2);

        @GET
        @Path(value="/{id}")
        @QueryParams(keys={"max-keys"}, values={"0"})
        public ListenableFuture<String> getQuery(@PathParam(value="id") String var1);

        @GET
        @Path(value="/{id}")
        @QueryParams(keys={"acl"})
        public ListenableFuture<String> getQueryNull(@PathParam(value="id") String var1);

        @GET
        @Path(value="/{id}")
        @QueryParams(keys={"acl"}, values={""})
        public ListenableFuture<String> getQueryEmpty(@PathParam(value="id") String var1);

        @PUT
        @Path(value="/{id}")
        public ListenableFuture<String> put(@PathParam(value="id") @ParamParser(value=FirstCharacter.class) String var1, @BinderParam(value=BindToStringPayload.class) String var2);

        @PUT
        @Path(value="/{id}")
        @VirtualHost
        public ListenableFuture<String> putOptions(@PathParam(value="id") String var1, HttpRequestOptions var2);

        @PUT
        @Path(value="/{id}")
        @Headers(keys={"foo"}, values={"--{id}--"})
        @ResponseParser(value=ReturnTrueIf2xx.class)
        public ListenableFuture<String> putHeader(@PathParam(value="id") String var1, @BinderParam(value=BindToStringPayload.class) String var2);
    }

    public static class ReturnStringIf200Context
    extends ReturnStringIf2xx
    implements InvocationContext<ReturnStringIf200Context> {
        public HttpRequest request;

        public ReturnStringIf200Context setContext(HttpRequest request) {
            this.request = request;
            return this;
        }
    }

    public static interface TestTransformers {
        @GET
        public ListenableFuture<Integer> noTransformer();

        @GET
        @ResponseParser(value=ReturnStringIf2xx.class)
        public ListenableFuture<Void> oneTransformer();

        @GET
        @ResponseParser(value=ReturnStringIf200Context.class)
        public ListenableFuture<Void> oneTransformerWithContext();

        @GET
        public ListenableFuture<InputStream> futureInputStream();

        @GET
        public ListenableFuture<URI> futureUri();

        @PUT
        public ListenableFuture<Void> put(org.jclouds.io.Payload var1);

        @PUT
        @Headers(keys={"Transfer-Encoding"}, values={"chunked"})
        public ListenableFuture<Void> putXfer(org.jclouds.io.Payload var1);

        @PUT
        public ListenableFuture<Void> put(PayloadEnclosing var1);
    }

    @QueryParams(keys={"x-amz-copy-source"}, values={"/{bucket}"})
    public class TestClassQuery {
        @GET
        @Path(value="/")
        public void oneQuery(@PathParam(value="bucket") String path) {
        }
    }

    public class TestQueryReplace {
        @GET
        @Path(value="/")
        public void queryInOptions(@PathParam(value="bucket") String path, TestReplaceQueryOptions options) {
        }

        @GET
        @Path(value="/")
        @QueryParams(keys={"x-amz-copy-source"}, values={"/{bucket}"})
        public void oneQuery(@PathParam(value="bucket") String path) {
        }

        @GET
        @Path(value="/")
        @QueryParams(keys={"slash", "hyphen"}, values={"/{bucket}", "-{bucket}"})
        public void twoQuery(@PathParam(value="bucket") String path) {
        }

        @GET
        @Path(value="/")
        @QueryParams(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoQuerys(@PathParam(value="bucket") String path, @PathParam(value="key") String path2) {
        }

        @GET
        @Path(value="/")
        @QueryParams(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoQuerysOutOfOrder(@PathParam(value="key") String path, @PathParam(value="bucket") String path2) {
        }
    }

    public class TestReplaceQueryOptions
    extends BaseHttpRequestOptions {
        public TestReplaceQueryOptions() {
            this.queryParameters.put((Object)"x-amz-copy-source", (Object)"/{bucket}");
        }
    }

    @Headers(keys={"x-amz-copy-source"}, values={"/{bucket}"})
    public class TestClassHeader {
        @GET
        @Path(value="/")
        public void oneHeader(@PathParam(value="bucket") String path) {
        }
    }

    public class TestHeader {
        @GET
        @Path(value="/")
        @Headers(keys={"x-amz-copy-source"}, values={"/{bucket}"})
        public void oneHeader(@PathParam(value="bucket") String path) {
        }

        @GET
        @Path(value="/")
        @Headers(keys={"slash", "hyphen"}, values={"/{bucket}", "-{bucket}"})
        public void twoHeader(@PathParam(value="bucket") String path) {
        }

        @GET
        @Path(value="/")
        @Headers(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoHeaders(@PathParam(value="bucket") String path, @PathParam(value="key") String path2) {
        }

        @GET
        @Path(value="/")
        @Headers(keys={"x-amz-copy-source"}, values={"/{bucket}/{key}"})
        public void twoHeadersOutOfOrder(@PathParam(value="key") String path, @PathParam(value="bucket") String path2) {
        }
    }

    static class FirstCharacterFirstElement
    implements Function<Object, String> {
        FirstCharacterFirstElement() {
        }

        public String apply(Object from) {
            return ((String)((Object[])from)[0]).substring(0, 1);
        }
    }

    static class FirstCharacter
    implements Function<Object, String> {
        FirstCharacter() {
        }

        public String apply(Object from) {
            return from.toString().substring(0, 1);
        }
    }

    public class TestPath {
        @GET
        @Path(value="/{path}")
        public void onePath(@PathParam(value="path") String path) {
        }

        @GET
        @Path(value="/{path}")
        public void onePathNullable(@Nullable @PathParam(value="path") String path) {
        }

        @GET
        @Path(value="/{path1}/{path2}")
        public void twoPaths(@PathParam(value="path1") String path, @PathParam(value="path2") String path2) {
        }

        @GET
        @Path(value="/{path2}/{path1}")
        public void twoPathsOutOfOrder(@PathParam(value="path1") String path, @PathParam(value="path2") String path2) {
        }

        @GET
        @Path(value="/{path}")
        public void onePathParamExtractor(@PathParam(value="path") @ParamParser(value=FirstCharacter.class) String path) {
        }

        @GET
        @Path(value="/")
        public void oneQueryParamExtractor(@QueryParam(value="one") @ParamParser(value=FirstCharacter.class) String one) {
        }

        @POST
        @Path(value="/")
        public void oneFormParamExtractor(@FormParam(value="one") @ParamParser(value=FirstCharacter.class) String one) {
        }
    }

    @Path(value="/v1/{identity}")
    public static interface TestConstantPathParam {
        @Named(value="testidentity")
        @PathParam(value="identity")
        public void setUsername();

        @GET
        @Path(value="/{path1}/{path2}")
        public void twoPaths(@PathParam(value="path1") String var1, @PathParam(value="path2") String var2);
    }

    public class TestEncoding {
        @GET
        @Path(value="/{path1}/{path2}")
        public void twoPaths(@PathParam(value="path1") String path, @PathParam(value="path2") String path2) {
        }
    }

    @RequestFilters(value={TestRequestFilter1.class})
    static interface TestRequestFilter {
        @GET
        @RequestFilters(value={TestRequestFilter2.class})
        public void get();

        @GET
        @OverrideRequestFilters
        @RequestFilters(value={TestRequestFilter2.class})
        public void getOverride();

        @OverrideRequestFilters
        @RequestFilters(value={TestRequestFilter2.class})
        public void getOverride(HttpRequest var1);

        @POST
        public void post();
    }

    static class TestRequestFilter2
    implements HttpRequestFilter {
        TestRequestFilter2() {
        }

        public HttpRequest filter(HttpRequest request) throws HttpException {
            return request;
        }
    }

    static class TestRequestFilter1
    implements HttpRequestFilter {
        TestRequestFilter1() {
        }

        public HttpRequest filter(HttpRequest request) throws HttpException {
            return request;
        }
    }

    static class View {
        String foo;

        View() {
        }
    }

    public static interface TestPut {
        @PUT
        @Path(value="/{foo}")
        @org.jclouds.rest.annotations.MapBinder(value=BindToJsonPayload.class)
        public void putWithMethodBinder(@PathParam(value="foo") @PayloadParam(value="fooble") String var1);

        @PUT
        @Path(value="/{foo}")
        @Produces(value={"text/plain"})
        public void putWithMethodBinderProduces(@PathParam(value="foo") @BinderParam(value=BindToStringPayload.class) String var1);

        @PUT
        @Path(value="/{foo}")
        @org.jclouds.rest.annotations.MapBinder(value=BindToJsonPayload.class)
        @Consumes(value={"application/json"})
        public View putWithMethodBinderConsumes(@PathParam(value="foo") @PayloadParam(value="fooble") String var1);

        @GET
        @Path(value="/")
        @Consumes(value={"application/json"})
        public Map<String, String> testGeneric();

        @GET
        @Path(value="/")
        @Consumes(value={"application/json"})
        public ListenableFuture<Map<String, String>> testGeneric2();

        @GET
        @Path(value="/")
        @Consumes(value={"application/json"})
        public ListenableFuture<? extends Map<String, String>> testGeneric3();

        @GET
        @Path(value="/")
        @Unwrap
        @Consumes(value={"application/json"})
        public String testUnwrap();

        @GET
        @Path(value="/")
        @SelectJson(value={"foo"})
        @Consumes(value={"application/json"})
        public String testUnwrapValueNamed();

        @POST
        @Path(value="/")
        public String testWrapWith(@WrapWith(value="foo") String var1);

        @GET
        @Path(value="/")
        @Unwrap
        @Consumes(value={"application/json"})
        public ListenableFuture<String> testUnwrap2();

        @GET
        @Path(value="/")
        @Unwrap
        @Consumes(value={"application/json"})
        public ListenableFuture<Set<String>> testUnwrap3();

        @GET
        @Path(value="/")
        @Unwrap
        @Consumes(value={"application/json"})
        public ListenableFuture<? extends Set<String>> testUnwrap4();

        @GET
        @Path(value="/")
        @SelectJson(value={"jobid"})
        public ListenableFuture<Long> selectLong();

        @GET
        @Path(value="/")
        @SelectJson(value={"jobid"})
        @Transform(value=AddOne.class)
        public ListenableFuture<Long> selectLongAddOne();

        @GET
        @Path(value="/")
        @SelectJson(value={"runit"})
        @OnlyElement
        @Consumes(value={"application/json"})
        public ListenableFuture<String> selectOnlyElement();

        @ROWDY
        @Path(value="/strings/{id}")
        public ListenableFuture<Boolean> rowdy(@PathParam(value="id") String var1);

        @ROWDY
        @Path(value="/ints/{id}")
        public ListenableFuture<Boolean> rowdy(@PathParam(value="id") int var1);

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        @HttpMethod(value="ROWDY")
        public static @interface ROWDY {
        }

        public static class AddOne
        implements Function<Long, Long> {
            public Long apply(Long o) {
                return o + 1L;
            }
        }
    }

    static interface TestMultipartForm {
        @POST
        public void withStringPart(@PartParam(name="fooble") String var1);

        @POST
        public void withParamStringPart(@FormParam(value="name") String var1, @PartParam(name="file") String var2);

        @POST
        public void withParamFilePart(@FormParam(value="name") String var1, @PartParam(name="file") File var2);

        @POST
        public void withParamFileBinaryPart(@FormParam(value="name") String var1, @PartParam(name="file", contentType="application/octet-stream") File var2);

        @POST
        public void withParamByteArrayBinaryPart(@FormParam(value="name") String var1, @PartParam(name="file", contentType="application/octet-stream", filename="{name}.tar.gz") byte[] var2);
    }

    public static interface TestPost {
        @POST
        public void post(@Nullable @BinderParam(value=BindToStringPayload.class) String var1);

        @POST
        public void postNonnull(@BinderParam(value=BindToStringPayload.class) String var1);

        @POST
        public void postAsJson(@BinderParam(value=BindToJsonPayload.class) String var1);

        @POST
        @Path(value="/{foo}")
        public void postWithPath(@PathParam(value="foo") @PayloadParam(value="fooble") String var1, org.jclouds.rest.annotations.MapBinder var2);

        @POST
        @Path(value="/{foo}")
        @org.jclouds.rest.annotations.MapBinder(value=BindToJsonPayload.class)
        public void postWithMethodBinder(@PathParam(value="foo") @PayloadParam(value="fooble") String var1);

        @POST
        @Path(value="/{foo}")
        @PayloadParams(keys={"rat"}, values={"atat"})
        @org.jclouds.rest.annotations.MapBinder(value=BindToJsonPayload.class)
        public void postWithMethodBinderAndDefaults(@PathParam(value="foo") @PayloadParam(value="fooble") String var1);

        @POST
        @Path(value="/{foo}")
        @PayloadParams(keys={"rat"}, values={"atat"})
        @Payload(value="name {fooble}")
        @Produces(value={"text/plain"})
        public void testPayload(@PathParam(value="foo") @PayloadParam(value="fooble") String var1);
    }

    public class TestOverriddenEndpoint
    implements Parent {
        @Override
        @POST
        @Endpoint(value=Localhost2.class)
        public void foo() {
        }

        @POST
        public void foo(@EndpointParam URI endpoint) {
        }
    }

    public class TestOverridden
    implements Parent {
        @Override
        @POST
        public void foo() {
        }
    }

    public static interface Parent {
        public void foo();
    }

    public class TestCustomMethod {
        @FOO
        public void foo() {
        }
    }

    private class TestHttpRequestOptions
    extends BaseHttpRequestOptions {
        private TestHttpRequestOptions() {
        }

        TestHttpRequestOptions payload(String payload) {
            this.payload = payload;
            return this;
        }

        TestHttpRequestOptions headerParams(Multimap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        TestHttpRequestOptions queryParams(Multimap<String, String> params) {
            this.queryParameters.putAll(params);
            return this;
        }
    }

    public static interface TestPayloadParamVarargs {
        @POST
        public void varargs(HttpRequestOptions ... var1);

        @POST
        public void varargsWithReq(String var1, HttpRequestOptions ... var2);

        @POST
        public void post(HttpRequestOptions var1);

        @POST
        @Produces(value={"application/octet-stream"})
        public void post();

        @POST
        @Produces(value={"application/octet-stream"})
        public void post(org.jclouds.io.Payload var1);
    }

    @QueryParams(keys={"x-ms-version"}, values={"2009-07-17"})
    public class TestQuery {
        @FOO
        @Path(value="/")
        @QueryParams(keys={"x-ms-rubbish"}, values={"bin"})
        public void foo() {
        }

        @FOO
        @Path(value="/")
        @QueryParams(keys={"foo", "fooble"}, values={"bar", "baz"})
        public void foo2() {
        }

        @FOO
        @Path(value="/")
        @QueryParams(keys={"foo", "fooble"}, values={"bar", "baz"})
        public void foo3(@QueryParam(value="robbie") String robbie) {
        }

        @FOO
        @Path(value="/")
        @QueryParams(keys={"foo", "fooble"}, values={"bar", "baz"})
        public void foo3Nullable(@Nullable @QueryParam(value="robbie") String robbie) {
        }

        @FOO
        @Path(value="/")
        public void queryParamIterable(@Nullable @QueryParam(value="foo") Iterable<String> bars) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface Localhost2 {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @HttpMethod(value="FOO")
    public static @interface FOO {
    }

    public static interface AsyncCaller
    extends Closeable {
        @Provides
        @Localhost2
        public URI getURI();

        @Delegate
        public AsyncCallee getCallee();

        @Delegate
        public AsyncCallee2 getCallee2();

        @Delegate
        public AsyncCallee getCallee(@EndpointParam URI var1);

        @Delegate
        public Optional<AsyncCallee> getOptionalCallee(@EndpointParam URI var1);

        @Delegate
        @Path(value="/testing/testing/{wibble}")
        public AsyncCallee getCalleeWithPath(@EndpointParam URI var1, @PathParam(value="wibble") String var2);
    }

    public static interface Callee2 {
        public void onePath(String var1);
    }

    public static interface Callee
    extends Closeable {
        public void onePath(String var1);
    }

    @Endpoint(value=Localhost2.class)
    public static interface Caller
    extends Closeable {
        @Provides
        @Localhost2
        public URI getURI();

        @Delegate
        public Callee getCallee();

        @Delegate
        public Callee2 getCallee2();

        @Delegate
        public Callee getCallee(@EndpointParam URI var1);

        @Delegate
        public Optional<Callee> getOptionalCallee(@EndpointParam URI var1);

        @Delegate
        @Path(value="/testing/testing/{wibble}")
        public Callee getCalleeWithPath(@EndpointParam URI var1, @PathParam(value="wibble") String var2);
    }

    @Path(value="/client/{jclouds.api-version}")
    public static interface AsyncCallee2 {
        @GET
        @Path(value="/{path}/2")
        public ListenableFuture<Void> onePath(@PathParam(value="path") String var1);
    }

    @Path(value="/client/{jclouds.api-version}")
    public static interface AsyncCallee
    extends Closeable {
        @GET
        @Path(value="/{path}")
        public ListenableFuture<Void> onePath(@PathParam(value="path") String var1);
    }

    @ConfiguresRestClient
    protected static class CallerModule
    extends RestClientModule<Caller, AsyncCaller> {
        CallerModule() {
            super((Map)ImmutableMap.of(Callee.class, AsyncCallee.class, Callee2.class, AsyncCallee2.class));
        }

        protected void configure() {
            super.configure();
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Localhost2.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("http://localhost:1111")));
            this.bind(IOExceptionRetryHandler.class).toInstance((Object)IOExceptionRetryHandler.NEVER_RETRY);
        }
    }
}

