/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.SetAndThrowAuthorizationExceptionSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplierTest")
public class SetAndThrowAuthorizationExceptionSupplierTest {
    @Test
    public void testNormal() {
        AtomicReference authException = Atomics.newReference();
        Assert.assertEquals((String)((String)new SetAndThrowAuthorizationExceptionSupplier(Suppliers.ofInstance((Object)"foo"), authException).get()), (String)"foo");
        Assert.assertEquals(authException.get(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AuthorizationException.class})
    public void testThrowsAuthorizationExceptionAndAlsoSetsExceptionType() {
        AtomicReference authException = Atomics.newReference();
        try {
            new SetAndThrowAuthorizationExceptionSupplier((Supplier)new Supplier<String>(){

                public String get() {
                    throw new AuthorizationException();
                }
            }, authException).get();
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), AuthorizationException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AuthorizationException.class})
    public void testThrowsAuthorizationExceptionAndAlsoSetsExceptionTypeWhenNested() {
        AtomicReference authException = Atomics.newReference();
        try {
            new SetAndThrowAuthorizationExceptionSupplier((Supplier)new Supplier<String>(){

                public String get() {
                    throw new RuntimeException(new ExecutionException(new AuthorizationException()));
                }
            }, authException).get();
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), AuthorizationException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={RuntimeException.class})
    public void testThrowsOriginalExceptionAndAlsoSetsExceptionTypeWhenNestedAndNotAuthorizationException() {
        AtomicReference authException = Atomics.newReference();
        try {
            new SetAndThrowAuthorizationExceptionSupplier((Supplier)new Supplier<String>(){

                public String get() {
                    throw new RuntimeException(new IllegalArgumentException("foo"));
                }
            }, authException).get();
        }
        finally {
            Assert.assertEquals(((Object)((Object)((AuthorizationException)((Object)authException.get())))).getClass(), RuntimeException.class);
        }
    }
}

