/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.test.testng;

import java.util.concurrent.atomic.AtomicInteger;
import org.testng.IClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class UnitTestStatusListener
implements ITestListener {
    private ThreadLocal<IClass> threadTestClass = new ThreadLocal();
    private ThreadLocal<Long> threadTestStart = new ThreadLocal();
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger succeded = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);

    public void onTestStart(ITestResult res) {
        System.out.println("Starting test " + this.getTestDesc(res));
        this.threadTestClass.set(res.getTestClass());
        this.threadTestStart.set(System.currentTimeMillis());
    }

    public synchronized void onTestSuccess(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " succeeded: " + (System.currentTimeMillis() - this.threadTestStart.get()) + "ms");
        this.succeded.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestFailure(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " failed.");
        this.failed.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestSkipped(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " skipped.");
        this.skipped.incrementAndGet();
        this.printStatus();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onStart(ITestContext arg0) {
    }

    public void onFinish(ITestContext arg0) {
    }

    private String getThreadId() {
        return "[" + Thread.currentThread().getName() + "]";
    }

    private String getTestDesc(ITestResult res) {
        return res.getMethod().getMethodName() + "(" + res.getTestClass().getName() + ")";
    }

    private void printStatus() {
        System.out.println("Test suite progress: tests succeeded: " + this.succeded.get() + ", failed: " + this.failed.get() + ", skipped: " + this.skipped.get() + ".");
    }
}

