/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class Strings2Test {
    public void testIsEncoded() {
        assert (Strings2.isUrlEncoded((String)"/read-tests/%73%6f%6d%65%20%66%69%6c%65"));
        assert (!Strings2.isUrlEncoded((String)"/read-tests/ tep"));
    }

    public void testNoDoubleEncode() {
        Assert.assertEquals((String)Strings2.urlEncode((String)"/read-tests/%73%6f%6d%65%20%66%69%6c%65", (char[])new char[]{'/'}), (String)"/read-tests/%73%6f%6d%65%20%66%69%6c%65");
        Assert.assertEquals((String)Strings2.urlEncode((String)"/read-tests/ tep", (char[])new char[]{'/'}), (String)"/read-tests/%20tep");
    }

    public void testReplaceTokens() {
        Assert.assertEquals((String)Strings2.replaceTokens((String)"hello {where}", (Map)ImmutableMap.of((Object)"where", (Object)"world")), (String)"hello world");
    }

    public void testUrlEncodeDecodeShouldGiveTheSameString() {
        String actual = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCc903twxU2zcQnIJdXv61RwZNZW94uId9qz08fgsBJsCOnHNIC4+L9kDOA2IHV9cUfEDBm1Be5TbpadWwSbS/05E+FARH2/MCO932UgcKUq5PGymS0249fLCBPci5zoLiG5vIym+1ij1hL/nHvkK99NIwe7io+Lmp9OcF3PTsm3Rgh5T09cRHGX9horp0VoAVa9vKJx6C1/IEHVnG8p0YPPa1lmemvx5kNBEiyoNQNYa34EiFkcJfP6rqNgvY8h/j4nE9SXoUCC/g6frhMFMOL0tzYqvz0Lczqm1Oh4RnSn3O9X4R934p28qqAobe337hmlLUdb6H5zuf+NwCh0HdZ";
        Assert.assertEquals((String)actual, (String)Strings2.urlDecode((Object)Strings2.urlEncode((String)actual, (char[])new char[0])));
    }
}

