/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.NoSuchElementException;
import org.jclouds.util.Suppliers2;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Suppliers2Test {
    @Test
    public void testGetLastValueInMap() {
        Assert.assertEquals((String)((String)Suppliers2.getLastValueInMap((Supplier)Suppliers.ofInstance((Object)ImmutableMap.of((Object)"foo", (Object)Suppliers.ofInstance((Object)"bar")))).get()), (String)"bar");
    }

    @Test
    public void testOfInstanceFunction() {
        Assert.assertEquals((Object)((Supplier)Suppliers2.ofInstanceFunction().apply((Object)"foo")).get(), (Object)"foo");
    }

    @Test
    public void testOrWhenFirstNull() {
        Assert.assertEquals((String)((String)Suppliers2.or((Supplier)Suppliers.ofInstance(null), (Supplier)Suppliers.ofInstance((Object)"foo")).get()), (String)"foo");
    }

    @Test
    public void testOrWhenFirstNotNull() {
        Assert.assertEquals((String)((String)Suppliers2.or((Supplier)Suppliers.ofInstance((Object)"foo"), (Supplier)Suppliers.ofInstance((Object)"bar")).get()), (String)"foo");
    }

    @Test
    public void testOnThrowableWhenFirstThrowsMatchingException() {
        Assert.assertEquals((String)((String)Suppliers2.onThrowable((Supplier)new Supplier<String>(){

            public String get() {
                throw new NoSuchElementException();
            }
        }, NoSuchElementException.class, (Supplier)Suppliers.ofInstance((Object)"foo")).get()), (String)"foo");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testOnThrowableWhenFirstThrowsUnmatchingException() {
        Suppliers2.onThrowable((Supplier)new Supplier<String>(){

            public String get() {
                throw new RuntimeException();
            }
        }, NoSuchElementException.class, (Supplier)Suppliers.ofInstance((Object)"foo")).get();
    }

    @Test
    public void testOnThrowableWhenFirstIsFine() {
        Assert.assertEquals((String)((String)Suppliers2.onThrowable((Supplier)Suppliers.ofInstance((Object)"foo"), NoSuchElementException.class, (Supplier)Suppliers.ofInstance((Object)"bar")).get()), (String)"foo");
    }

    @Test
    public void testCombination() {
        Supplier alternate = Suppliers.ofInstance((Object)"bar");
        Supplier or = Suppliers2.or((Supplier)Suppliers.ofInstance((Object)"foo"), (Supplier)alternate);
        Supplier combined = Suppliers2.onThrowable((Supplier)or, NoSuchElementException.class, (Supplier)alternate);
        Assert.assertEquals((String)((String)combined.get()), (String)"foo");
    }
}

