/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.jclouds.functions.ToLowerCase;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Multimaps2;

public class HttpMessage
extends PayloadEnclosingImpl {
    protected final Multimap<String, String> headers;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpMessage(this);
    }

    protected HttpMessage(Multimap<String, String> headers, @Nullable Payload payload) {
        super(payload);
        this.headers = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(headers, (Object)"headers")));
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public String getFirstHeaderOrNull(String string) {
        Collection values = this.headers.get((Object)string);
        if (values.size() == 0) {
            Multimap<String, String> lowerCaseHeaders = Multimaps2.transformKeys(this.getHeaders(), new ToLowerCase());
            values = lowerCaseHeaders.get((Object)string.toLowerCase());
        }
        return values.size() >= 1 ? (String)values.iterator().next() : null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.headers, this.payload});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpMessage)) {
            return false;
        }
        HttpMessage that = (HttpMessage)HttpMessage.class.cast(obj);
        return Objects.equal(this.headers, that.headers) && Objects.equal((Object)this.payload, (Object)that.payload);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("headers", this.headers).add("payload", (Object)this.payload);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ImmutableMultimap.Builder<String, String> headers = ImmutableMultimap.builder();
        protected Payload payload;

        protected abstract T self();

        public T payload(Payload payload) {
            this.payload = payload;
            return this.self();
        }

        public T payload(byte[] payload) {
            this.payload = Payloads.newByteArrayPayload((byte[])Preconditions.checkNotNull((Object)payload, (Object)"payload"));
            return this.self();
        }

        public T payload(File payload) {
            this.payload = Payloads.newFilePayload((File)Preconditions.checkNotNull((Object)payload, (Object)"payload"));
            return this.self();
        }

        public T payload(InputStream payload) {
            this.payload = Payloads.newInputStreamPayload((InputStream)Preconditions.checkNotNull((Object)payload, (Object)"payload"));
            return this.self();
        }

        public T payload(String payload) {
            this.payload = Payloads.newStringPayload((String)Preconditions.checkNotNull((Object)payload, (Object)"payload"));
            return this.self();
        }

        public T headers(Multimap<String, String> headers) {
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll((Multimap)Preconditions.checkNotNull(headers, (Object)"headers"));
            return this.self();
        }

        public T replaceHeaders(Multimap<String, String> headers) {
            Preconditions.checkNotNull(headers, (Object)"headers");
            ImmutableMultimap oldHeaders = this.headers.build();
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll(Multimaps2.replaceEntries(oldHeaders, headers));
            return this.self();
        }

        public T removeHeader(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            ImmutableMultimap oldHeaders = this.headers.build();
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll(Multimaps2.withoutKey(oldHeaders, name));
            return this.self();
        }

        public T addHeader(String name, String ... values) {
            this.headers.putAll(Preconditions.checkNotNull((Object)name, (Object)"name"), (Object[])Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name}));
            return this.self();
        }

        public T replaceHeader(String name, String ... values) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name});
            return this.replaceHeaders((Multimap<String, String>)ImmutableMultimap.builder().putAll((Object)name, (Object[])values).build());
        }

        public HttpMessage build() {
            return new HttpMessage((Multimap<String, String>)this.headers.build(), this.payload);
        }

        public T fromHttpMessage(HttpMessage in) {
            return ((Builder)this.headers(in.getHeaders())).payload(in.getPayload());
        }
    }
}

