/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.RestApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.util.TypeToken2;

@Beta
public abstract class BaseRestApiMetadata
extends BaseApiMetadata
implements RestApiMetadata {
    protected final Class<?> api;
    protected final Class<?> asyncApi;

    protected BaseRestApiMetadata(Builder<?> builder) {
        super(builder);
        this.api = (Class)Preconditions.checkNotNull(builder.api, (Object)"api");
        this.asyncApi = (Class)Preconditions.checkNotNull(builder.asyncApi, (Object)"asyncApi");
    }

    public static Properties defaultProperties() {
        Properties props = BaseApiMetadata.defaultProperties();
        return props;
    }

    public static <S, A> TypeToken<RestContext<S, A>> contextToken(TypeToken<S> apiToken, TypeToken<A> asyncApiToken) {
        return new TypeToken2<RestContext<S, A>>(){
            private static final long serialVersionUID = 1L;
        }.where(new TypeToken2.TypeParameter2<S>(){}, apiToken, new TypeToken2.TypeParameter2<A>(){}, asyncApiToken);
    }

    @Override
    public Class<?> getApi() {
        return this.api;
    }

    @Override
    public Class<?> getAsyncApi() {
        return this.asyncApi;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("api", this.getApi()).add("asyncApi", this.getAsyncApi());
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseApiMetadata.Builder<T>
    implements RestApiMetadata.Builder<T> {
        protected Class<?> api;
        protected Class<?> asyncApi;

        protected Builder(Class<?> api, Class<?> asyncApi) {
            Preconditions.checkNotNull(api, (Object)"api");
            Preconditions.checkNotNull(asyncApi, (Object)"asyncApi");
            ((Builder)((Builder)((BaseApiMetadata.Builder)((Object)this.javaApi((Class)api, (Class)asyncApi))).name(String.format("%s->%s", api.getSimpleName(), asyncApi.getSimpleName()))).context((TypeToken)BaseRestApiMetadata.contextToken(Reflection2.typeToken(api), Reflection2.typeToken(asyncApi)))).defaultProperties(BaseRestApiMetadata.defaultProperties());
        }

        @Override
        public T javaApi(Class<?> api, Class<?> asyncApi) {
            this.api = (Class)Preconditions.checkNotNull(api, (Object)"api");
            this.asyncApi = (Class)Preconditions.checkNotNull(asyncApi, (Object)"asyncApi");
            return (T)((Builder)this.self());
        }

        @Override
        public T fromApiMetadata(ApiMetadata in) {
            if (in instanceof RestApiMetadata) {
                RestApiMetadata rest = (RestApiMetadata)RestApiMetadata.class.cast(in);
                this.javaApi((Class)rest.getApi(), (Class)rest.getAsyncApi());
            }
            super.fromApiMetadata(in);
            return (T)((Builder)this.self());
        }
    }
}

