/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import org.jclouds.scriptbuilder.domain.Call;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CallTest {
    public void testCallNoArgsUNIX() {
        Call call = new Call("help", new String[0]);
        Assert.assertEquals((String)call.render(OsFamily.UNIX), (String)"help || return 1\n");
    }

    public void testCallNoArgsWINDOWS() {
        Call call = new Call("help", new String[0]);
        Assert.assertEquals((String)call.render(OsFamily.WINDOWS), (String)"call :help\r\nif errorlevel 1 goto abort\r\n");
    }

    public void testCallArgsUNIX() {
        Call call = new Call("help", new String[]{"me", "rhonda"});
        Assert.assertEquals((String)call.render(OsFamily.UNIX), (String)"help me rhonda || return 1\n");
    }

    public void testCallArgsWINDOWS() {
        Call call = new Call("help", new String[]{"me", "rhonda"});
        Assert.assertEquals((String)call.render(OsFamily.WINDOWS), (String)"call :help me rhonda\r\nif errorlevel 1 goto abort\r\n");
    }
}

