/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import org.jclouds.scriptbuilder.domain.chef.Role;
import org.jclouds.scriptbuilder.domain.chef.RunList;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RoleTest")
public class RoleTest {
    public void testToJsonStringWithOnlyName() {
        Role role = Role.builder().name("foo").build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[]}");
    }

    public void testToJsonStringWithDescription() {
        Role role = Role.builder().name("foo").description("Foo role").build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"Foo role\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[]}");
    }

    public void testToJsonStringWithDefaultAttributes() {
        Role role = Role.builder().name("foo").jsonDefaultAttributes("{\"foo\":\"bar\"}").build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{\"foo\":\"bar\"},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[]}");
    }

    public void testToJsonStringWithOverrideAttributes() {
        Role role = Role.builder().name("foo").jsonOverrideAttributes("{\"foo\":\"bar\"}").build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{\"foo\":\"bar\"},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[]}");
    }

    public void testToJsonStringWithSingleRecipe() {
        RunList runlist = RunList.builder().recipe("apache2").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[\"recipe[apache2]\"]}");
    }

    public void testToJsonStringWithMultipleRecipes() {
        RunList runlist = RunList.builder().recipe("apache2").recipe("git").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[\"recipe[apache2]\",\"recipe[git]\"]}");
    }

    public void testToJsonStringWithSingleRole() {
        RunList runlist = RunList.builder().role("webserver").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[\"role[webserver]\"]}");
    }

    public void testToJsonStringWithMultipleRoles() {
        RunList runlist = RunList.builder().role("webserver").role("firewall").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[\"role[webserver]\",\"role[firewall]\"]}");
    }

    public void testToJsonStringWithRolesAndRecipes() {
        RunList runlist = RunList.builder().role("webserver").recipe("git").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        Assert.assertEquals((String)role.toJsonString(), (String)"{\"name\": \"foo\",\"description\":\"\",\"default_attributes\":{},\"override_attributes\":{},\"json_class\":\"Chef::Role\",\"chef_type\":\"role\",\"run_list\":[\"role[webserver]\",\"recipe[git]\"]}");
    }
}

