/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.chef;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.chef.InstallChefGems;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="InstallChefGemsTest")
public class InstallChefGemsTest {
    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="windows not yet implemented")
    public void installChefGemsInWindows() {
        InstallChefGems.builder().build().render(OsFamily.WINDOWS);
    }

    public void installChefGemsUnix() throws IOException {
        Assert.assertEquals((String)InstallChefGems.builder().build().render(OsFamily.UNIX), (String)"gem install chef --no-rdoc --no-ri\n");
    }

    public void installChefGemsUnixWithCustomVersion() throws IOException {
        Assert.assertEquals((String)InstallChefGems.builder().version(">= 0.10.8").build().render(OsFamily.UNIX), (String)"gem install chef -v '>= 0.10.8' --no-rdoc --no-ri\n");
    }

    public void installChefGemsUnixInScriptBuilder() throws IOException {
        Assert.assertEquals((String)InitScript.builder().name("install_chef_gems").run((Statement)InstallChefGems.builder().build()).build().render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_install_chef_gems_scriptbuilder." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }
}

