/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ruby;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.ruby.InstallRuby;
import org.jclouds.scriptbuilder.statements.ruby.InstallRubyGems;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="InstallRubyGemsTest")
public class InstallRubyGemsTest {
    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="windows not yet implemented")
    public void installRubyGemsInWindows() {
        new InstallRuby().render(OsFamily.WINDOWS);
    }

    public void installRubyGemsDefaultsUnix() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().build().render(OsFamily.UNIX), (String)InstallRubyGemsTest.installRubyGems("1.8.10"));
    }

    public void installRubyGemsForcingVersion() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().version("1.8.25").build().render(OsFamily.UNIX), (String)InstallRubyGemsTest.installRubyGems("1.8.25"));
    }

    public void installRubyGemsAndUpdateSystem() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().updateSystem(true).build().render(OsFamily.UNIX), (String)(InstallRubyGemsTest.installRubyGems("1.8.10") + InstallRubyGemsTest.updateSystem(null)));
    }

    public void installRubyGemsAndUpdateSystemForcingUpdateVersion() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().updateSystem(true, "1.8.25").build().render(OsFamily.UNIX), (String)(InstallRubyGemsTest.installRubyGems("1.8.10") + InstallRubyGemsTest.updateSystem("1.8.25")));
    }

    public void installRubyGemsAndUpdateGems() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().updateExistingGems(true).build().render(OsFamily.UNIX), (String)(InstallRubyGemsTest.installRubyGems("1.8.10") + InstallRubyGemsTest.updateGems()));
    }

    public void installRubyGemsUpdatingSystemAndGems() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().version("1.2.3").updateSystem(true, "1.2.4").updateExistingGems(true).build().render(OsFamily.UNIX), (String)(InstallRubyGemsTest.installRubyGems("1.2.3") + InstallRubyGemsTest.updateSystem("1.2.4") + InstallRubyGemsTest.updateGems()));
    }

    public void installRubyGemsDefaultsWithUpgrade() throws IOException {
        Assert.assertEquals((String)InstallRubyGems.builder().updateSystem(true).updateExistingGems(true).build().render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_install_rubygems." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    public void installRubyGemsUnixDefaultsInScriptBuilder() throws IOException {
        Assert.assertEquals((String)InitScript.builder().name("install_rubygems").run((Statement)InstallRubyGems.builder().build()).build().render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_install_rubygems_scriptbuilder." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    private static String installRubyGems(String version) {
        String script = "if ! hash gem 2>/dev/null; then\n(\nmkdir /tmp/$$\ncurl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET  http://production.cf.rubygems.org/rubygems/rubygems-" + version + ".tgz |(mkdir -p /tmp/$$ &&cd /tmp/$$ &&tar -xpzf -)\n" + "mkdir -p /tmp/rubygems\n" + "mv /tmp/$$/*/* /tmp/rubygems\n" + "rm -rf /tmp/$$\n" + "cd /tmp/rubygems\n" + "ruby setup.rb --no-format-executable\n" + "rm -fr /tmp/rubygems\n" + ")\n" + "fi\n";
        return script;
    }

    private static String updateSystem(String version) {
        return version == null ? "gem update --system\n" : "gem update --system " + version + "\n";
    }

    private static String updateGems() {
        return "gem update --no-rdoc --no-ri\n";
    }
}

