/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import com.google.common.collect.ImmutableSet;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AuthorizeRSAPublicKeyTest {
    public void testAuthorizeRSAPublicKeyUNIXCurrentUser() {
        Assert.assertEquals((String)new AuthorizeRSAPublicKeys((Iterable)ImmutableSet.of((Object)"ssh-dss AAAAB")).render(OsFamily.UNIX), (String)"mkdir -p ~/.ssh\ncat >> ~/.ssh/authorized_keys <<-'END_OF_JCLOUDS_FILE'\n\tssh-dss AAAAB\nEND_OF_JCLOUDS_FILE\nchmod 600 ~/.ssh/authorized_keys\n");
    }

    public void testAuthorizeRSAPublicKeyUNIXCurrentUserWith2Keys() {
        Assert.assertEquals((String)new AuthorizeRSAPublicKeys((Iterable)ImmutableSet.of((Object)"ssh-dss AAAAB", (Object)"ssh-dss CCCCD")).render(OsFamily.UNIX), (String)"mkdir -p ~/.ssh\ncat >> ~/.ssh/authorized_keys <<-'END_OF_JCLOUDS_FILE'\n\tssh-dss AAAAB\n\t\n\tssh-dss CCCCD\nEND_OF_JCLOUDS_FILE\nchmod 600 ~/.ssh/authorized_keys\n");
    }

    public void testAuthorizeRSAPublicKeyUNIXSpecifiedDir() {
        Assert.assertEquals((String)new AuthorizeRSAPublicKeys("/home/me/.ssh", (Iterable)ImmutableSet.of((Object)"ssh-dss AAAAB")).render(OsFamily.UNIX), (String)"mkdir -p /home/me/.ssh\ncat >> /home/me/.ssh/authorized_keys <<-'END_OF_JCLOUDS_FILE'\n\tssh-dss AAAAB\nEND_OF_JCLOUDS_FILE\nchmod 600 /home/me/.ssh/authorized_keys\n");
    }

    public void testAuthorizeRSAPublicKeyUNIXSpecifiedDirWith2Keys() {
        Assert.assertEquals((String)new AuthorizeRSAPublicKeys("/home/me/.ssh", (Iterable)ImmutableSet.of((Object)"ssh-dss AAAAB", (Object)"ssh-dss CCCCD")).render(OsFamily.UNIX), (String)"mkdir -p /home/me/.ssh\ncat >> /home/me/.ssh/authorized_keys <<-'END_OF_JCLOUDS_FILE'\n\tssh-dss AAAAB\n\t\n\tssh-dss CCCCD\nEND_OF_JCLOUDS_FILE\nchmod 600 /home/me/.ssh/authorized_keys\n");
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAuthorizeRSAPublicKeyWINDOWS() {
        new AuthorizeRSAPublicKeys((Iterable)ImmutableSet.of((Object)"ssh-dss AAAAB")).render(OsFamily.WINDOWS);
    }
}

