/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.net.UnknownHostException;
import java.util.Map;
import org.jclouds.aws.ec2.binders.BindLaunchSpecificationToFormParams;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindLaunchSpecificationToFormParamsTest {
    BindLaunchSpecificationToFormParams binder = new BindLaunchSpecificationToFormParams();

    @Test
    public void testApplyWithBlockDeviceMappings() throws UnknownHostException {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").mapNewVolumeToDevice("/dev/sda1", 120, true).build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.BlockDeviceMapping.1.DeviceName", (Object)"/dev/sda1", (Object)"LaunchSpecification.BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"120", (Object)"LaunchSpecification.BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"true"));
    }

    @Test
    public void testApplyWithUserData() throws UnknownHostException {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").userData("hello".getBytes()).build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.UserData", (Object)BaseEncoding.base64().encode("hello".getBytes(Charsets.UTF_8))));
    }

    @Test
    public void testApplyWithSecurityId() throws UnknownHostException {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").securityGroupId("sid-foo").build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.SecurityGroupId.1", (Object)"sid-foo"));
    }

    @Test
    public void testApplyWithSubnetId() throws UnknownHostException {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").subnetId("subnet-xyz").build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.SubnetId", (Object)"subnet-xyz"));
    }

    @Test
    public void testApplyWithIAMInstanceProfileArn() {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").iamInstanceProfileArn("arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver").build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.IamInstanceProfile.Arn", (Object)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver"));
    }

    @Test
    public void testApplyWithIAMInstanceProfileName() {
        LaunchSpecification spec = LaunchSpecification.builder().instanceType("t1.micro").imageId("ami-123").iamInstanceProfileName("Webserver").build();
        Assert.assertEquals((Map)this.binder.apply(spec), (Map)ImmutableMap.of((Object)"LaunchSpecification.InstanceType", (Object)"t1.micro", (Object)"LaunchSpecification.ImageId", (Object)"ami-123", (Object)"LaunchSpecification.IamInstanceProfile.Name", (Object)"Webserver"));
    }
}

