/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.EC2TemplateBuilderLiveTest;
import org.jclouds.ec2.compute.predicates.EC2ImagePredicates;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionAsyncClient;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.internal.TrackingJavaUrlHttpCommandExecutorService;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AWSEC2TemplateBuilderLiveTest")
public class AWSEC2TemplateBuilderLiveTest
extends EC2TemplateBuilderLiveTest {
    public AWSEC2TemplateBuilderLiveTest() {
        this.provider = "aws-ec2";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return true;
                    }
                    case DEBIAN: {
                        return true;
                    }
                    case RHEL: {
                        return input.version.equals("5.6") || input.version.equals("") || input.version.matches("[56].0") && input.is64Bit;
                    }
                    case CENTOS: {
                        return input.version.matches("5.[0246]") || input.version.equals("6.0") && input.is64Bit || input.version.equals("");
                    }
                    case WINDOWS: {
                        return input.version.matches("200[38]") || input.version.equals("7") && !input.is64Bit || input.version.equals("");
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testTemplateBuilderM1MEDIUMWithNegativeLookaroundDoesntMatchTestImages() {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().hardwareId("m1.medium").osVersionMatches("1[012].[10][04]").imageDescriptionMatches("^(?!.*(daily|testing)).*ubuntu-images.*$").osFamily(OsFamily.UBUNTU).build();
        assert (template.getImage().getProviderId().startsWith("ami-")) : template;
        assert (template.getImage().getDescription().indexOf("test") == -1) : template;
        assert (template.getImage().getDescription().indexOf("daily") == -1) : template;
        Assert.assertEquals((String)template.getImage().getVersion(), (String)"20100224");
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)false);
        Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
        Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
        Assert.assertEquals((String)template.getHardware().getId(), (String)"m1.medium");
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    @Test
    public void testUbuntuInstanceStoreGoesM1SmallNegativeLookaroundDoesntMatchTestImages() {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().imageMatches(EC2ImagePredicates.rootDeviceType((RootDeviceType)RootDeviceType.INSTANCE_STORE)).osVersionMatches("1[012].[10][04]").imageDescriptionMatches("^(?!.*(daily|testing)).*ubuntu-images.*$").osFamily(OsFamily.UBUNTU).build();
        assert (template.getImage().getProviderId().startsWith("ami-")) : template;
        assert (template.getImage().getDescription().indexOf("test") == -1) : template;
        assert (template.getImage().getDescription().indexOf("daily") == -1) : template;
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)false);
        Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
        Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
        Assert.assertEquals((String)template.getHardware().getId(), (String)"m1.small");
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    @Test
    public void testTemplateBuilderCanUseImageIdAndhardwareIdAndAZ() {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().imageId("us-east-1/ami-ccb35ea5").hardwareId("m2.2xlarge").locationId("us-east-1a").build();
        System.out.println(template.getHardware());
        assert (template.getImage().getProviderId().startsWith("ami-")) : template;
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"5.4");
        Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
        Assert.assertEquals((String)template.getImage().getVersion(), (String)"4.4.10");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
        Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-1a");
        Assert.assertEquals((String)template.getImage().getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)4.0);
        Assert.assertEquals((String)template.getHardware().getId(), (String)"m2.2xlarge");
        Assert.assertEquals((String)template.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        assert (defaultTemplate.getImage().getProviderId().startsWith("ami-")) : defaultTemplate;
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"pv-2012.09.rc-1");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.AMZN_LINUX);
        Assert.assertEquals((String)((String)defaultTemplate.getImage().getUserMetadata().get("rootDeviceType")), (String)"ebs");
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    @Test
    public void testAmazonLinuxInstanceStore() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().osFamily(OsFamily.AMZN_LINUX).imageMatches(EC2ImagePredicates.rootDeviceType((RootDeviceType)RootDeviceType.INSTANCE_STORE)).build();
        assert (defaultTemplate.getImage().getProviderId().startsWith("ami-")) : defaultTemplate;
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"pv-2012.09.rc-1");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.AMZN_LINUX);
        Assert.assertEquals((String)((String)defaultTemplate.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    @Test
    public void testFastestTemplateBuilder() throws IOException {
        Template fastestTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().fastest().osFamily(OsFamily.AMZN_LINUX).build();
        assert (fastestTemplate.getImage().getProviderId().startsWith("ami-")) : fastestTemplate;
        Assert.assertEquals((String)fastestTemplate.getHardware().getProviderId(), (String)"cc2.8xlarge");
        Assert.assertEquals((String)fastestTemplate.getImage().getOperatingSystem().getVersion(), (String)"2011.09.2");
        Assert.assertEquals((boolean)fastestTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)fastestTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.AMZN_LINUX);
        Assert.assertEquals((String)((String)fastestTemplate.getImage().getUserMetadata().get("rootDeviceType")), (String)"ebs");
        Assert.assertEquals((String)fastestTemplate.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)fastestTemplate.getHardware()), (Object)16.0);
        Assert.assertEquals((String)fastestTemplate.getImage().getOperatingSystem().getArch(), (String)"hvm");
    }

    @Test
    public void testTemplateBuilderMicro() throws IOException {
        Template microTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().hardwareId("t1.micro").osFamily(OsFamily.UBUNTU).osVersionMatches("10.10").os64Bit(true).build();
        assert (microTemplate.getImage().getProviderId().startsWith("ami-")) : microTemplate;
        Assert.assertEquals((String)microTemplate.getImage().getOperatingSystem().getVersion(), (String)"10.10");
        Assert.assertEquals((boolean)microTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)microTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)((String)microTemplate.getImage().getUserMetadata().get("rootDeviceType")), (String)"ebs");
        Assert.assertEquals((String)microTemplate.getLocation().getId(), (String)"us-east-1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)microTemplate.getHardware()), (Object)1.0);
        Assert.assertEquals((String)microTemplate.getImage().getOperatingSystem().getArch(), (String)"paravirtual");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderWithNoOwnersParsesImageOnDemand() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.ec2.ami-query", "");
            overrides.setProperty("jclouds.ec2.cc-ami-query", "");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Assert.assertEquals((int)context.getComputeService().listImages().size(), (int)0);
            Template template = context.getComputeService().templateBuilder().imageId("us-east-1/ami-ccb35ea5").build();
            System.out.println(template.getHardware());
            assert (template.getImage().getProviderId().startsWith("ami-")) : template;
            Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"5.4");
            Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)true);
            Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
            Assert.assertEquals((String)template.getImage().getVersion(), (String)"4.4.10");
            Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
            Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-1");
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
            Assert.assertEquals((String)template.getHardware().getId(), (String)"m1.small");
            Assert.assertEquals((int)context.getComputeService().listImages().size(), (int)1);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderWithNoOwnersParsesImageOnDemandDeprecated() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.ec2.ami-owners", "");
            overrides.setProperty("jclouds.ec2.cc-ami-query", "");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Assert.assertEquals((int)context.getComputeService().listImages().size(), (int)0);
            Template template = context.getComputeService().templateBuilder().imageId("us-east-1/ami-ccb35ea5").build();
            System.out.println(template.getHardware());
            assert (template.getImage().getProviderId().startsWith("ami-")) : template;
            Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"5.4");
            Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)true);
            Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
            Assert.assertEquals((String)template.getImage().getVersion(), (String)"4.4.10");
            Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
            Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-1");
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
            Assert.assertEquals((String)template.getHardware().getId(), (String)"m1.small");
            Assert.assertEquals((int)context.getComputeService().listImages().size(), (int)1);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderWithLessRegions() throws IOException, SecurityException, NoSuchMethodException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.regions", "eu-west-1");
            overrides.setProperty("jclouds.ec2.cc-regions", "");
            overrides.setProperty("jclouds.ec2.ami-query", "");
            overrides.setProperty("jclouds.ec2.cc-ami-query", "");
            ArrayList commandsInvoked = Lists.newArrayList();
            context = (ComputeServiceContext)this.createView(overrides, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)TrackingJavaUrlHttpCommandExecutorService.newTrackingModule((List)commandsInvoked)));
            assert (context.getComputeService().listAssignableLocations().size() < ((ComputeServiceContext)this.view).getComputeService().listAssignableLocations().size());
            AWSEC2TemplateBuilderLiveTest.assertOnlyOneRegionQueriedForAvailabilityZone(commandsInvoked);
            assert (context.getComputeService().listImages().size() < ((ComputeServiceContext)this.view).getComputeService().listImages().size());
            Template template = context.getComputeService().templateBuilder().imageId("eu-west-1/ami-a33b06d7").build();
            assert (template.getImage().getProviderId().startsWith("ami-")) : template;
            Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)"2011.09.2");
            Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)true);
            Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.AMZN_LINUX);
            Assert.assertEquals((String)template.getImage().getVersion(), (String)"2011.09.2");
            Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"instance-store");
            Assert.assertEquals((String)template.getLocation().getId(), (String)"eu-west-1");
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
            Assert.assertEquals((String)template.getHardware().getId(), (String)"m1.small");
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private static void assertOnlyOneRegionQueriedForAvailabilityZone(List<HttpCommand> commandsInvoked) throws NoSuchMethodException {
        assert (commandsInvoked.size() == 2) : commandsInvoked;
        Assert.assertEquals((Object)TrackingJavaUrlHttpCommandExecutorService.getInvokerOfRequestAtIndex(commandsInvoked, (int)0), (Object)AvailabilityZoneAndRegionAsyncClient.class.getMethod("describeRegions", DescribeRegionsOptions[].class));
        Assert.assertEquals((Object)TrackingJavaUrlHttpCommandExecutorService.getInvokerOfRequestAtIndex(commandsInvoked, (int)1), (Object)AvailabilityZoneAndRegionAsyncClient.class.getMethod("describeAvailabilityZonesInRegion", String.class, DescribeAvailabilityZonesOptions[].class));
    }

    @Test
    public void testTemplateBuilderCanUseImageIdFromNonDefaultOwner() {
        String imageId = "us-east-1/ami-44d02f2d";
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().imageId(imageId).imageMatches(EC2ImagePredicates.rootDeviceType((RootDeviceType)RootDeviceType.INSTANCE_STORE)).build();
        assert (defaultTemplate.getImage().getProviderId().startsWith("ami-")) : defaultTemplate;
        Assert.assertEquals((String)defaultTemplate.getImage().getId(), (String)imageId);
    }

    @Test
    public void testAssignability() {
        ((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN);
        ((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"US-VA", (Object)"US-CA", (Object)"US-OR", (Object)"BR-SP", (Object)"IE", (Object)"SG", (Object[])new String[]{"AU-NSW", "JP-13"});
    }
}

