/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.parse;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.xml.AWSDescribeInstancesResponseHandler;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSDescribeInstancesResponseHandlerTest")
public class DescribeInstancesResponseTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_instances_pending.xml");
        Set<Reservation<AWSRunningInstance>> expected = this.expected();
        AWSDescribeInstancesResponseHandler handler = (AWSDescribeInstancesResponseHandler)this.injector.getInstance(AWSDescribeInstancesResponseHandler.class);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public Set<Reservation<AWSRunningInstance>> expected() {
        return ImmutableSet.of((Object)Reservation.builder().region(this.defaultRegion).reservationId("r-3f056a58").ownerId("095072994936").groupName("launchpad_sec_group").groupName("jclouds#4c858090-f66c-4225-aa57-6fcaa42198ae").instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).instanceId("i-32451248")).imageId("ami-bf8131d6")).rawState("pending")).instanceState(InstanceState.PENDING)).privateDnsName("ip-10-194-149-220.ec2.internal")).dnsName("ec2-23-20-17-42.compute-1.amazonaws.com")).keyName("jclouds#4c858090-f66c-4225-aa57-6fcaa42198ae#105")).amiLaunchIndex("0")).instanceType("c1.medium")).launchTime(this.dateService.iso8601DateParse("2012-09-14T20:01:34.000Z"))).availabilityZone("us-east-1d")).kernelId("aki-825ea7eb")).monitoringState(MonitoringState.DISABLED).privateIpAddress("10.194.149.220")).ipAddress("23.20.17.42")).securityGroupIdToName("sg-f788299f", "launchpad_sec_group").securityGroupIdToName("sg-7e512116", "jclouds#4c858090-f66c-4225-aa57-6fcaa42198ae").rootDeviceType(RootDeviceType.EBS)).rootDeviceName("/dev/sda1")).device("/dev/sda1", new BlockDevice("vol-b2beb3c9", Attachment.Status.ATTACHING, this.dateService.iso8601DateParse("2012-09-14T20:01:37.000Z"), true))).virtualizationType("paravirtual")).tag("Name", "4c858090-f66c-4225-aa57-6fcaa42198ae-32451248")).hypervisor(Hypervisor.XEN).build()).build());
    }
}

