/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.services.AWSInstanceClient;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSInstanceClientLiveTest
extends BaseComputeServiceContextLiveTest {
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";
    private AWSInstanceClient client;

    public AWSInstanceClientLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = ((AWSEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getInstanceServices();
    }

    @Test
    void testDescribeInstances() {
        for (String region : ((AWSEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getAvailabilityZoneAndRegionServices().describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            Set allResults = this.client.describeInstancesInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
            assert (allResults.size() >= 0) : allResults.size();
        }
    }
}

