/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import java.util.Set;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.aws.ec2.services.AWSSecurityGroupClient;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.services.SecurityGroupClientLiveTest;
import org.jclouds.ec2.util.IpPermissions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSSecurityGroupClientLiveTest
extends SecurityGroupClientLiveTest {
    public AWSSecurityGroupClientLiveTest() {
        this.provider = "aws-ec2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressIpPermission() throws InterruptedException {
        final String group1Name = PREFIX + "ingress11";
        String group2Name = PREFIX + "ingress12";
        this.cleanupAndSleep(group2Name);
        this.cleanupAndSleep(group1Name);
        try {
            String group1Id = ((AWSSecurityGroupClient)AWSSecurityGroupClient.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group1Name, group1Name, new CreateSecurityGroupOptions[0]);
            String group2Id = ((AWSSecurityGroupClient)AWSSecurityGroupClient.class.cast(this.client)).createSecurityGroupInRegionAndReturnId(null, group2Name, group2Name, new CreateSecurityGroupOptions[0]);
            Thread.sleep(100L);
            this.ensureGroupsExist(group1Name, group2Name);
            ((AWSSecurityGroupClient)AWSSecurityGroupClient.class.cast(this.client)).authorizeSecurityGroupIngressInRegion(null, group1Id, (IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(80));
            AWSSecurityGroupClientLiveTest.assertEventually((Runnable)new SecurityGroupClientLiveTest.GroupHasPermission(this.client, group1Name, (Predicate)new SecurityGroupClientLiveTest.TCPPort80AllIPs((SecurityGroupClientLiveTest)this)));
            Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{group1Name});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            final SecurityGroup group = (SecurityGroup)oneResult.iterator().next();
            Assert.assertEquals((String)group.getName(), (String)group1Name);
            IpPermissions group2CanHttpGroup1 = IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(80).originatingFromSecurityGroupId(group1Id);
            ((AWSSecurityGroupClient)AWSSecurityGroupClient.class.cast(this.client)).authorizeSecurityGroupIngressInRegion(null, group2Id, (IpPermission)group2CanHttpGroup1);
            AWSSecurityGroupClientLiveTest.assertEventually((Runnable)new SecurityGroupClientLiveTest.GroupHasPermission(this.client, group2Name, (Predicate)new Predicate<IpPermission>(){

                public boolean apply(IpPermission arg0) {
                    return arg0.getUserIdGroupPairs().equals((Object)ImmutableMultimap.of((Object)group.getOwnerId(), (Object)group1Name)) && arg0.getFromPort() == 80 && arg0.getToPort() == 80 && arg0.getIpProtocol() == IpProtocol.TCP;
                }
            }));
            ((AWSSecurityGroupClient)AWSSecurityGroupClient.class.cast(this.client)).revokeSecurityGroupIngressInRegion(null, group2Id, (IpPermission)group2CanHttpGroup1);
            AWSSecurityGroupClientLiveTest.assertEventually((Runnable)new SecurityGroupClientLiveTest.GroupHasNoPermissions(this.client, group2Name));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, group2Name);
            this.client.deleteSecurityGroupInRegion(null, group1Name);
        }
    }
}

