/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2ProviderMetadata;
import org.jclouds.aws.ec2.config.AWSEC2RestClientModule;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.compute.domain.Image;
import org.jclouds.date.DateService;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.util.Suppliers2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseAWSEC2AsyncClientTest<T>
extends BaseAsyncClientTest<T> {
    protected FormSigner filter;
    protected String provider = "aws-ec2";

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), FormSigner.class);
    }

    @BeforeTest
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.filter = (FormSigner)this.injector.getInstance(FormSigner.class);
    }

    protected Module createModule() {
        return new StubAWSEC2RestClientModule();
    }

    public AWSEC2ProviderMetadata createProviderMetadata() {
        return new AWSEC2ProviderMetadata();
    }

    @ConfiguresRestClient
    protected static class StubAWSEC2RestClientModule
    extends AWSEC2RestClientModule {
        protected StubAWSEC2RestClientModule() {
        }

        protected String provideTimeStamp(DateService dateService) {
            return "2009-11-08T15:54:08.897Z";
        }

        @Provides
        @Singleton
        LoadingCache<RegionAndName, Image> provide() {
            return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RegionAndName, Image>(){

                public Image load(RegionAndName key) throws Exception {
                    return null;
                }
            });
        }

        protected void installLocations() {
            this.install((Module)new LocationModule());
            this.bind(RegionIdToURISupplier.class).toInstance((Object)new RegionIdToURISupplier(){

                public Map<String, Supplier<URI>> get() {
                    return Maps.transformValues((Map)ImmutableMap.of((Object)"eu-west-1", (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"), (Object)"us-east-1", (Object)URI.create("https://ec2.us-east-1.amazonaws.com"), (Object)"us-west-1", (Object)URI.create("https://ec2.us-west-1.amazonaws.com")), (Function)Suppliers2.ofInstanceFunction());
                }
            });
            this.bind(RegionIdToZoneIdsSupplier.class).toInstance((Object)new RegionIdToZoneIdsSupplier(){

                public Map<String, Supplier<Set<String>>> get() {
                    return Maps.transformValues((Map)ImmutableMap.of((Object)"us-east-1", (Object)ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b", (Object)"us-east-1c", (Object)"us-east-1b")), (Function)Suppliers2.ofInstanceFunction());
                }
            });
        }
    }
}

