/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.aws.ec2.services.BaseAWSEC2AsyncClientTest;
import org.jclouds.aws.ec2.services.MonitoringAsyncClient;
import org.jclouds.aws.ec2.xml.MonitoringStateHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MonitoringAsyncClientTest")
public class MonitoringAsyncClientTest
extends BaseAWSEC2AsyncClientTest<MonitoringAsyncClient> {
    public void testUnmonitorInstances() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(MonitoringAsyncClient.class, (String)"unmonitorInstancesInRegion", (Class[])new Class[]{String.class, String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "instance1", "instance2"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        String payload = "Action=UnmonitorInstances&InstanceId.0=instance1&InstanceId.1=instance2";
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, payload, "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, MonitoringStateHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testMonitorInstances() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(MonitoringAsyncClient.class, (String)"monitorInstancesInRegion", (Class[])new Class[]{String.class, String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "instance1", "instance2"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=MonitorInstances&InstanceId.0=instance1&InstanceId.1=instance2", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, MonitoringStateHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

