/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.predicates.PlacementGroupAvailable;
import org.jclouds.aws.ec2.predicates.PlacementGroupDeleted;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.rest.RestContext;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.java.InstallJDK;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="PlacementGroupClientLiveTest")
public class PlacementGroupClientLiveTest
extends BaseComputeServiceContextLiveTest {
    ArrayList<String> supportedRegions = Lists.newArrayList((Object[])new String[]{"us-east-1", "us-west-2", "eu-west-1"});
    private AWSEC2Client client;
    private Predicate<PlacementGroup> availableTester;
    private Predicate<PlacementGroup> deletedTester;
    private PlacementGroup group;
    public static final String PREFIX = System.getProperty("user.name") + "ec2";

    public PlacementGroupClientLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (AWSEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.availableTester = Predicates2.retry((Predicate)new PlacementGroupAvailable(this.client), (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.deletedTester = Predicates2.retry((Predicate)new PlacementGroupDeleted(this.client), (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    void testDescribe() {
        for (String region : this.supportedRegions) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.getPlacementGroupServices().describePlacementGroupsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            PlacementGroup group = (PlacementGroup)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.getPlacementGroupServices().describePlacementGroupsInRegion(region, new String[]{group.getName()}));
            Assert.assertNotNull((Object)result);
            PlacementGroup compare = (PlacementGroup)result.last();
            Assert.assertEquals((Object)compare, (Object)group);
        }
        for (String region : this.client.getAvailabilityZoneAndRegionServices().describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            if (this.supportedRegions.contains(region)) continue;
            try {
                this.client.getPlacementGroupServices().describePlacementGroupsInRegion(region, new String[0]);
                Assert.fail((String)("should be unsupported for region: " + region));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    @Test
    void testCreatePlacementGroup() {
        String groupName = PREFIX + "1";
        for (String region : this.supportedRegions) {
            this.client.getPlacementGroupServices().deletePlacementGroupInRegion(region, groupName);
            this.client.getPlacementGroupServices().createPlacementGroupInRegion(region, groupName);
            this.verifyPlacementGroup(region, groupName);
        }
    }

    private void verifyPlacementGroup(String region, String groupName) {
        assert (this.availableTester.apply((Object)new PlacementGroup(region, groupName, "cluster", PlacementGroup.State.PENDING))) : this.group;
        Set oneResult = this.client.getPlacementGroupServices().describePlacementGroupsInRegion(region, new String[]{groupName});
        Assert.assertNotNull((Object)oneResult);
        Assert.assertEquals((int)oneResult.size(), (int)1);
        this.group = (PlacementGroup)oneResult.iterator().next();
        Assert.assertEquals((String)this.group.getName(), (String)groupName);
        Assert.assertEquals((String)this.group.getStrategy(), (String)"cluster");
        assert (this.availableTester.apply((Object)this.group)) : this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartCCInstance() throws Exception {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().fromHardware(EC2HardwareBuilder.cc2_8xlarge().build()).osFamily(OsFamily.AMZN_LINUX).build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)template.getHardware().getProviderId(), (String)"cc2.8xlarge");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("rootDeviceType")), (String)"ebs");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("virtualizationType")), (String)"hvm");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("hypervisor")), (String)"xen");
        template.getOptions().runScript(Statements.newStatementList((Statement[])new Statement[]{AdminAccess.standard(), InstallJDK.fromOpenJDK()}));
        String group = PREFIX + "cccluster";
        ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        this.client.getPlacementGroupServices().deletePlacementGroupInRegion(null, "jclouds#" + group + "#us-east-1");
        try {
            Set nodes = ((ComputeServiceContext)this.view).getComputeService().createNodesInGroup(group, 1, template);
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes);
            Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)this.client.getInstanceServices().describeInstancesInRegion(null, new String[]{node.getProviderId()}))));
        }
        catch (RunNodesException e) {
            System.err.println(e.getNodeErrors().keySet());
            Throwables.propagate((Throwable)e);
        }
        finally {
            ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.group != null) {
            this.client.getPlacementGroupServices().deletePlacementGroupInRegion(this.group.getRegion(), this.group.getName());
            assert (this.deletedTester.apply((Object)this.group)) : this.group;
        }
        super.tearDownContext();
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

