/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.jclouds.aws.ec2.services.BaseAWSEC2AsyncClientTest;
import org.jclouds.aws.ec2.services.SpotInstanceAsyncClient;
import org.jclouds.aws.ec2.xml.DescribeSpotPriceHistoryResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SpotInstanceAsyncClientTest")
public class SpotInstanceAsyncClientTest
extends BaseAWSEC2AsyncClientTest<SpotInstanceAsyncClient> {
    Date from = new Date(12345678910L);
    Date to = new Date(1234567891011L);

    public void testCancelSpotInstanceRequests() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SpotInstanceAsyncClient.class, (String)"cancelSpotInstanceRequestsInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=CancelSpotInstanceRequests&SpotInstanceRequestId.1=id", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSpotPriceHistory() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SpotInstanceAsyncClient.class, (String)"describeSpotPriceHistoryInRegion", (Class[])new Class[]{String.class, DescribeSpotPriceHistoryOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSpotPriceHistory", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSpotPriceHistoryResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSpotPriceHistoryArgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SpotInstanceAsyncClient.class, (String)"describeSpotPriceHistoryInRegion", (Class[])new Class[]{String.class, DescribeSpotPriceHistoryOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, DescribeSpotPriceHistoryOptions.Builder.from((Date)this.from).to(this.to).productDescription("description").instanceType("m1.small")}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSpotPriceHistory&StartTime=1970-05-23T21%3A21%3A18.910Z&EndTime=2009-02-13T23%3A31%3A31.011Z&ProductDescription=description&InstanceType.1=m1.small", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSpotPriceHistoryResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

