/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.xml.SpotInstanceHandler;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SpotInstanceHandlerTest")
public class SpotInstanceHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/request_spot_instances-ebs.xml");
        SpotInstanceRequest expected = SpotInstanceRequest.builder().region("us-east-1").id("sir-228e6406").spotPrice(0.001f).type(SpotInstanceRequest.Type.ONE_TIME).state(SpotInstanceRequest.State.OPEN).rawState("open").launchSpecification(LaunchSpecification.builder().imageId("ami-595a0a1c").securityGroupIdToName("sg-83e1c4ea", "default").instanceType("m1.large").mapNewVolumeToDevice("/dev/sda1", 1, true).mapEBSSnapshotToDevice("/dev/sda2", "snap-1ea27576", Integer.valueOf(1), true).mapEphemeralDeviceToDevice("/dev/sda3", "vre1").monitoringEnabled(Boolean.valueOf(false)).iamInstanceProfileArn("arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver").iamInstanceProfileName("Webserver").build()).createTime(new SimpleDateFormatDateService().iso8601DateParse("2011-03-08T03:30:36.000Z")).productDescription("Linux/UNIX").build();
        SpotInstanceHandler handler = (SpotInstanceHandler)this.injector.getInstance(SpotInstanceHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        SpotInstanceRequest result = (SpotInstanceRequest)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
        Assert.assertEquals((Object)result.getState(), (Object)SpotInstanceRequest.State.OPEN);
        Assert.assertEquals((String)result.getRawState(), (String)"open");
        Assert.assertEquals((String)((String)((LaunchSpecification.IAMInstanceProfileRequest)result.getLaunchSpecification().getIAMInstanceProfile().get()).getArn().get()), (String)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
        Assert.assertEquals((String)((String)((LaunchSpecification.IAMInstanceProfileRequest)result.getLaunchSpecification().getIAMInstanceProfile().get()).getName().get()), (String)"Webserver");
    }

    public void testApplyInputStream1() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_spot_instance.xml");
        SpotInstanceRequest expected = SpotInstanceRequest.builder().region("us-east-1").id("sir-1ede0012").instanceId("i-ef308e8e").spotPrice(0.3f).type(SpotInstanceRequest.Type.ONE_TIME).state(SpotInstanceRequest.State.ACTIVE).rawState("active").launchedAvailabilityZone("us-east-1b").launchSpecification(LaunchSpecification.builder().imageId("ami-8e1fece7").securityGroupIdToName("sg-83e1c4eb", "jclouds#adriancole-ec2unssh#us-east-1").instanceType("t1.micro").monitoringEnabled(Boolean.valueOf(false)).keyName("jclouds#adriancole-ec2unssh").build()).createTime(new SimpleDateFormatDateService().iso8601DateParse("2011-07-29T05:27:39.000Z")).productDescription("Linux/UNIX").tag("Name", "ec2-o").tag("Spot", "spot-value").tag("Empty", "").build();
        SpotInstanceHandler handler = (SpotInstanceHandler)this.injector.getInstance(SpotInstanceHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        SpotInstanceRequest result = (SpotInstanceRequest)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
        Assert.assertEquals((Object)result.getState(), (Object)SpotInstanceRequest.State.ACTIVE);
        Assert.assertEquals((String)result.getRawState(), (String)"active");
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

