/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Singleton;
import org.jclouds.aws.s3.AWSS3AsyncClient;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.filters.AWSRequestAuthorizeSignature;
import org.jclouds.aws.s3.predicates.validators.AWSS3BucketNameValidator;
import org.jclouds.location.Region;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3RestClientModule;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.predicates.validators.BucketNameValidator;

@ConfiguresRestClient
public class AWSS3RestClientModule
extends S3RestClientModule<AWSS3Client, AWSS3AsyncClient> {
    public AWSS3RestClientModule() {
        super(Reflection2.typeToken(AWSS3Client.class), Reflection2.typeToken(AWSS3AsyncClient.class));
    }

    protected Supplier<String> defaultRegionForBucket(@Region Supplier<String> defaultRegion) {
        return Suppliers.ofInstance((Object)"us-standard");
    }

    protected void configure() {
        this.bind(BucketNameValidator.class).to(AWSS3BucketNameValidator.class);
        super.configure();
    }

    protected void bindRequestSigner() {
        this.bind(RequestAuthorizeSignature.class).to(AWSRequestAuthorizeSignature.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    S3Client provide(AWSS3Client in) {
        return in;
    }

    @Singleton
    @Provides
    S3AsyncClient provide(AWSS3AsyncClient in) {
        return in;
    }
}

