/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobFallbacks;
import org.jclouds.azureblob.binders.BindAzureBlobMetadataToRequest;
import org.jclouds.azureblob.binders.BindAzureBlocksToRequest;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.functions.BlobName;
import org.jclouds.azureblob.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.azureblob.functions.ParseBlobPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParseContainerPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.azureblob.predicates.validators.BlockIdValidator;
import org.jclouds.azureblob.predicates.validators.ContainerNameValidator;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.azureblob.xml.BlobBlocksResultsHandler;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.XMLResponseParser;

@Deprecated
@RequestFilters(value={SharedKeyLiteAuthentication.class})
@Headers(keys={"x-ms-version"}, values={"2009-09-19"})
@SkipEncoding(value={47, 36})
@Path(value="/")
public interface AzureBlobAsyncClient {
    @Provides
    public AzureBlob newBlob();

    @Named(value="ListContainers")
    @GET
    @XMLResponseParser(value=AccountNameEnumerationResultsHandler.class)
    @QueryParams(keys={"comp"}, values={"list"})
    public ListenableFuture<? extends BoundedSet<ContainerProperties>> listContainers(ListOptions ... var1);

    @Named(value="CreateContainer")
    @PUT
    @Path(value="{container}")
    @Fallback(value=AzureBlobFallbacks.FalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Boolean> createContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, CreateContainerOptions ... var2);

    @Named(value="GetContainerACL")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "acl"})
    @ResponseParser(value=ParsePublicAccessHeader.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    public ListenableFuture<PublicAccess> getPublicAccessForContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="GetContainerProperties")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @ResponseParser(value=ParseContainerPropertiesFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    public ListenableFuture<ContainerProperties> getContainerProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="GetContainerProperties")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @Fallback(value=BlobStoreFallbacks.FalseOnContainerNotFound.class)
    public ListenableFuture<Boolean> containerExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="SetContainerMetadata")
    @PUT
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "metadata"})
    public ListenableFuture<Void> setResourceMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var2);

    @Named(value="DeleteContainer")
    @DELETE
    @Path(value="{container}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Void> deleteContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="CreateContainer")
    @PUT
    @Path(value="$root")
    @Fallback(value=AzureBlobFallbacks.FalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Boolean> createRootContainer(CreateContainerOptions ... var1);

    @Named(value="DeleteContainer")
    @DELETE
    @Path(value="$root")
    @Fallback(value=Fallbacks.TrueOnNotFoundOr404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Void> deleteRootContainer();

    @Named(value="ListBlobs")
    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListenableFuture<ListBlobsResponse> listBlobs(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, ListBlobsOptions ... var2);

    @Named(value="ListBlobs")
    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="$root")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListenableFuture<ListBlobsResponse> listBlobs(ListBlobsOptions ... var1);

    @Named(value="PutBlob")
    @PUT
    @Path(value="{container}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> putBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") @ParamParser(value=BlobName.class) @BinderParam(value=BindAzureBlobMetadataToRequest.class) AzureBlob var2);

    @Named(value="GetBlob")
    @GET
    @ResponseParser(value=ParseBlobFromHeadersAndHttpContent.class)
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<AzureBlob> getBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, GetOptions ... var3);

    @Named(value="GetBlobProperties")
    @HEAD
    @ResponseParser(value=ParseBlobPropertiesFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<BlobProperties> getBlobProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="GetBlobProperties")
    @HEAD
    @Fallback(value=BlobStoreFallbacks.FalseOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<Boolean> blobExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="SetBlobMetadata")
    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"metadata"})
    public ListenableFuture<Void> setBlobMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var3);

    @Named(value="DeleteBlob")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<Void> deleteBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="PutBlock")
    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"block"})
    public ListenableFuture<Void> putBlock(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @QueryParam(value="blockid") @ParamValidators(value={BlockIdValidator.class}) String var3, Payload var4);

    @Named(value="PutBlockList")
    @PUT
    @Path(value="{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    @QueryParams(keys={"comp"}, values={"blocklist"})
    public ListenableFuture<String> putBlockList(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindAzureBlocksToRequest.class) List<String> var3);

    @Named(value="GetBlockList")
    @GET
    @Path(value="{container}/{name}")
    @XMLResponseParser(value=BlobBlocksResultsHandler.class)
    @QueryParams(keys={"comp"}, values={"blocklist"})
    public ListenableFuture<ListBlobBlocksResponse> getBlockList(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);
}

