/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class BlobPropertiesToBlobMetadata
implements Function<BlobProperties, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    private final LoadingCache<String, PublicAccess> containerAcls;

    @Inject
    public BlobPropertiesToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName, LoadingCache<String, PublicAccess> containerAcls) {
        this.ifDirectoryReturnName = (IfDirectoryReturnNameStrategy)Preconditions.checkNotNull((Object)ifDirectoryReturnName, (Object)"ifDirectoryReturnName");
        this.containerAcls = (LoadingCache)Preconditions.checkNotNull(containerAcls, (Object)"containerAcls");
    }

    public MutableBlobMetadata apply(BlobProperties from) {
        String directoryName;
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setUserMetadata(from.getMetadata());
        to.setETag(from.getETag());
        to.setLastModified(from.getLastModified());
        to.setName(from.getName());
        to.setContainer(from.getContainer());
        to.setUri(from.getUrl());
        if (from.getContainer() != null) {
            try {
                PublicAccess containerAcl = (PublicAccess)((Object)this.containerAcls.getUnchecked((Object)from.getContainer()));
                if (containerAcl != PublicAccess.PRIVATE) {
                    to.setPublicUri(from.getUrl());
                }
            }
            catch (CacheLoader.InvalidCacheLoadException e) {
                // empty catch block
            }
        }
        if ((directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to)) != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }
}

