/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.Item;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.VNC;
import org.jclouds.javax.annotation.Nullable;

public class Server
extends Item {
    protected final int cpu;
    protected final Integer smp;
    protected final int mem;
    protected final boolean persistent;
    @Nullable
    protected final Map<String, Device> devices;
    protected final Set<String> bootDeviceIds;
    protected final List<NIC> nics;
    protected final VNC vnc;
    @Nullable
    private final String description;

    public Server(@Nullable String uuid, String name, int cpu, @Nullable Integer smp, int mem, boolean persistent, Map<String, ? extends Device> devices, Iterable<String> bootDeviceIds, Iterable<String> use, Iterable<NIC> nics, VNC vnc, String description) {
        super(uuid, name, use);
        this.cpu = cpu;
        this.smp = smp;
        this.mem = mem;
        this.persistent = persistent;
        this.devices = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(devices, (Object)"devices")));
        this.bootDeviceIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(bootDeviceIds, (Object)"bootDeviceIds")));
        this.nics = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nics, (Object)"nics")));
        this.vnc = (VNC)Preconditions.checkNotNull((Object)vnc, (Object)"vnc");
        this.description = description;
    }

    public int getCpu() {
        return this.cpu;
    }

    public Integer getSmp() {
        return this.smp;
    }

    public int getMem() {
        return this.mem;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Map<String, Device> getDevices() {
        return this.devices;
    }

    public Set<String> getBootDeviceIds() {
        return this.bootDeviceIds;
    }

    public List<NIC> getNics() {
        return this.nics;
    }

    public VNC getVnc() {
        return this.vnc;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bootDeviceIds == null ? 0 : this.bootDeviceIds.hashCode());
        result = 31 * result + this.cpu;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.devices == null ? 0 : this.devices.hashCode());
        result = 31 * result + this.mem;
        result = 31 * result + (this.nics == null ? 0 : this.nics.hashCode());
        result = 31 * result + (this.persistent ? 1231 : 1237);
        result = 31 * result + (this.smp == null ? 0 : this.smp.hashCode());
        result = 31 * result + (this.vnc == null ? 0 : this.vnc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (this.bootDeviceIds == null ? other.bootDeviceIds != null : !this.bootDeviceIds.equals(other.bootDeviceIds)) {
            return false;
        }
        if (this.cpu != other.cpu) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.devices == null ? other.devices != null : !this.devices.equals(other.devices)) {
            return false;
        }
        if (this.mem != other.mem) {
            return false;
        }
        if (this.nics == null ? other.nics != null : !this.nics.equals(other.nics)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        if (this.smp == null ? other.smp != null : !this.smp.equals(other.smp)) {
            return false;
        }
        return !(this.vnc == null ? other.vnc != null : !this.vnc.equals(other.vnc));
    }

    @Override
    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", use=" + this.use + ", cpu=" + this.cpu + ", smp=" + this.smp + ", mem=" + this.mem + ", persistent=" + this.persistent + ", devices=" + this.devices + ", bootDeviceIds=" + this.bootDeviceIds + ", nics=" + this.nics + ", vnc=" + this.vnc + ", description=" + this.description + "]";
    }

    public static class Builder
    extends Item.Builder {
        protected int cpu;
        protected Integer smp;
        protected int mem;
        protected boolean persistent;
        protected Map<String, ? extends Device> devices = ImmutableMap.of();
        protected Set<String> bootDeviceIds = ImmutableSet.of();
        protected List<NIC> nics = ImmutableList.of();
        protected VNC vnc;
        protected String description;

        public Builder cpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder smp(Integer smp) {
            this.smp = smp;
            return this;
        }

        public Builder mem(int mem) {
            this.mem = mem;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder devices(Map<String, ? extends Device> devices) {
            this.devices = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(devices, (Object)"devices")));
            return this;
        }

        public Builder bootDeviceIds(Iterable<String> bootDeviceIds) {
            this.bootDeviceIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(bootDeviceIds, (Object)"bootDeviceIds")));
            return this;
        }

        public Builder nics(Iterable<NIC> nics) {
            this.nics = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nics, (Object)"nics")));
            return this;
        }

        public Builder vnc(VNC vnc) {
            this.vnc = vnc;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder use(Iterable<String> use) {
            return (Builder)Builder.class.cast(super.use(use));
        }

        @Override
        public Server build() {
            return new Server(this.uuid, this.name, this.cpu, this.smp, this.mem, this.persistent, this.devices, this.bootDeviceIds, this.use, this.nics, this.vnc, this.description);
        }

        public static Builder fromServer(Server in) {
            return ((Builder)new Builder().uuid(in.getUuid()).name(in.getName()).cpu(in.getCpu()).mem(in.getMem()).persistent(in.isPersistent()).description(in.getDescription()).devices(in.getDevices()).bootDeviceIds(in.getBootDeviceIds()).use(in.getUse())).nics(in.getNics()).vnc(in.getVnc());
        }
    }
}

