/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudsigma.CloudSigmaApiMetadata;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.compute.CloudSigmaComputeServiceLiveTest;
import org.jclouds.cloudsigma.compute.CloudSigmaTemplateBuilderImpl;
import org.jclouds.cloudsigma.compute.options.CloudSigmaTemplateOptions;
import org.jclouds.cloudsigma.domain.AffinityType;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudSigmaZurichComputeServiceLiveTest")
public class CloudSigmaZurichComputeServiceLiveTest
extends CloudSigmaComputeServiceLiveTest {
    public CloudSigmaZurichComputeServiceLiveTest() {
        this.provider = "cloudsigma-zrh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartNodeWithSSD() throws RunNodesException {
        String group = this.group + "-ssd";
        TemplateBuilder builder = this.client.templateBuilder();
        assert (builder instanceof CloudSigmaTemplateBuilderImpl);
        Template template = builder.options((TemplateOptions)CloudSigmaTemplateOptions.Builder.diskDriveAffinity((AffinityType)AffinityType.SSD)).build();
        assert (template.getOptions() instanceof CloudSigmaTemplateOptions);
        try {
            Set nodes = this.client.createNodesInGroup(group, 1, template);
            NodeMetadata node = (NodeMetadata)Iterables.get((Iterable)nodes, (int)0);
            CloudSigmaClient api = (CloudSigmaClient)CloudSigmaClient.class.cast(((RestContext)this.client.getContext().unwrap(CloudSigmaApiMetadata.CONTEXT_TOKEN)).getApi());
            ServerInfo serverInfo = api.getServerInfo(node.getId());
            Device rootDevice = (Device)Iterables.get(serverInfo.getDevices().values(), (int)0);
            DriveInfo driveInfo = api.getDriveInfo(rootDevice.getDriveUuid());
            Assert.assertTrue((boolean)Iterables.contains((Iterable)driveInfo.getTags(), (Object)"affinity:ssd"));
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }
}

